const baseUrl = "http://localhost:8002";
const http = {
  fetchWithToken: async (url, options = {}) => {
    const res = await chrome.storage.local.get("token");
    const token = res.token || "";
    const headers = {
      "Content-Type": "application/json",
      ...options.headers
    };
    if (token) headers["Authorization"] = token;
    const timeout = options.timeout || 9e4;
    const controller = new AbortController();
    const id = setTimeout(() => controller.abort(), timeout);
    try {
      const response = await fetch(`${baseUrl}${url}`, {
        ...options,
        headers,
        signal: controller.signal
      });
      clearTimeout(id);
      return await response.json();
    } catch (error) {
      clearTimeout(id);
      if (error.name === "AbortError") {
        return { code: 500, msg: "请求超时，AI 响应过慢" };
      }
      throw error;
    }
  },
  get: (url) => http.fetchWithToken(url, { method: "GET" }),
  post: (url, data) => http.fetchWithToken(url, { method: "POST", body: JSON.stringify(data) })
};
var text = ``;
var currentHistoryId = null;
var autoReplyEnabled = true;
window.onload = function() {
  console.log("[Boss插件] detail.js 已加载");
  chrome.storage.local.get(["text", "aiGeneratedText"], (data) => {
    console.log("[Boss插件] 从storage获取的text:", data.text, "aiGeneratedText:", data.aiGeneratedText);
    if (data.aiGeneratedText) {
      text = data.aiGeneratedText;
      chrome.storage.local.remove("aiGeneratedText");
      console.log("[Boss插件] 使用 AI 生成的打招呼语:", text);
    } else if (data.text) {
      text = data.text;
    }
    chrome.storage.local.get(["isRunning", "autoReply"], (config) => {
      if (config.isRunning) {
        autoReplyEnabled = config.autoReply !== false;
        var bootstrapDelay = Math.floor(Math.random() * (600 - 300 + 1)) + 300;
        console.log(`[Boss插件] 页面就绪，将在 ${bootstrapDelay}ms 后执行投递动作...`);
        var T = setTimeout(() => {
          clearTimeout(T);
          startProgram();
        }, bootstrapDelay);
      }
    });
  });
};
function extractJobInfo() {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u;
  const info = {};
  info.jobTitle = (_a = document.querySelector(".info-primary .name h1")) == null ? void 0 : _a.innerText.trim();
  info.salaryRange = (_b = document.querySelector(".info-primary .name .salary")) == null ? void 0 : _b.innerText.trim();
  info.city = (_c = document.querySelector(".info-primary .text-city")) == null ? void 0 : _c.innerText.trim();
  info.experience = (_d = document.querySelector(".info-primary .text-experiece")) == null ? void 0 : _d.innerText.trim();
  info.education = (_e = document.querySelector(".info-primary .text-degree")) == null ? void 0 : _e.innerText.trim();
  info.companyName = ((_f = document.querySelector(".job-sider .company-info a:not([ka])")) == null ? void 0 : _f.innerText.trim()) || ((_g = document.querySelector(".company-info .name")) == null ? void 0 : _g.innerText.trim());
  const stageEl = document.evaluate("//i[contains(@class, 'icon-stage')]/parent::p", document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue;
  info.companyStage = stageEl == null ? void 0 : stageEl.innerText.trim();
  const scaleEl = document.evaluate("//i[contains(@class, 'icon-scale')]/parent::p", document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue;
  info.companyScale = scaleEl == null ? void 0 : scaleEl.innerText.trim();
  const industryEl = (_i = (_h = document.querySelector(".job-sider .icon-industry")) == null ? void 0 : _h.parentElement) == null ? void 0 : _i.innerText.trim();
  info.companyIndustry = industryEl;
  info.companyFullName = (_j = document.querySelector(".level-list .company-name")) == null ? void 0 : _j.innerText.replace("公司名称", "").trim();
  info.legalRepresentative = (_k = document.querySelector(".level-list .company-user")) == null ? void 0 : _k.innerText.replace("法定代表人", "").trim();
  info.establishDate = (_l = document.querySelector(".level-list .res-time")) == null ? void 0 : _l.innerText.replace("成立日期", "").trim();
  info.registeredCapital = (_m = document.querySelector(".level-list .company-fund")) == null ? void 0 : _m.innerText.replace("注册资金", "").trim();
  info.enterpriseType = (_n = document.querySelector(".level-list .company-type")) == null ? void 0 : _n.innerText.replace("企业类型", "").trim();
  info.managementState = (_o = document.querySelector(".level-list .manage-state")) == null ? void 0 : _o.innerText.replace("经营状态", "").trim();
  info.companyAddress = (_p = document.querySelector(".location-address")) == null ? void 0 : _p.innerText.trim();
  const mapEl = document.querySelector(".js-open-map");
  if (mapEl) {
    const latLng = (_q = mapEl.getAttribute("data-lat")) == null ? void 0 : _q.split(",");
    if (latLng && latLng.length === 2) {
      info.longitude = latLng[0];
      info.latitude = latLng[1];
    }
  }
  const tags = [];
  document.querySelectorAll(".job-tags span").forEach((s) => tags.push(s.innerText.trim()));
  info.benefits = tags.join(",");
  const keywords = [];
  document.querySelectorAll(".job-keyword-list li").forEach((li) => keywords.push(li.innerText.trim()));
  info.jobKeywords = keywords.join(",");
  info.jobDescription = (_r = document.querySelector(".job-sec-text")) == null ? void 0 : _r.innerText.trim();
  info.publisher = (_s = document.querySelector(".job-boss-info .name")) == null ? void 0 : _s.innerText.replace(/今日活跃|刚刚活跃|.+活跃/, "").trim();
  info.publisherTitle = (_t = document.querySelector(".boss-info-attr")) == null ? void 0 : _t.innerText.trim();
  info.bossActiveState = (_u = document.querySelector(".boss-active-time")) == null ? void 0 : _u.innerText.trim();
  info.jobUrl = window.location.href;
  const urlParams = new URLSearchParams(window.location.search);
  const startChatBtn = document.querySelector(".btn-startchat");
  if (startChatBtn) {
    const dataUrl = startChatBtn.getAttribute("data-url") || startChatBtn.getAttribute("redirect-url");
    const match = dataUrl == null ? void 0 : dataUrl.match(/jobId=([^&]+)/);
    info.jobId = match ? match[1] : urlParams.get("jobId");
  }
  info.status = "wait";
  return info;
}
async function startProgram() {
  console.log("[Boss插件] startProgram 开始执行");
  const config = await chrome.storage.local.get(["skipChatted", "token"]);
  const isSkipChatted = config.skipChatted === void 0 ? true : config.skipChatted === true || config.skipChatted === 1;
  console.log("[Boss插件] 跳过已沟通配置:", isSkipChatted, "原始值:", config.skipChatted);
  var chatBtn = document.querySelector(".btn-startchat");
  if (!chatBtn) {
    chatBtn = document.querySelector(".btn .btn-startchat");
  }
  if (chatBtn) {
    const btnText = chatBtn.textContent.trim();
    console.log("[Boss插件] 沟通按钮文本:", btnText);
    if (isSkipChatted && (btnText.includes("继续沟通") || btnText.includes("已沟通"))) {
      console.log("[Boss插件] 检测到已沟通状态，跳过此职位");
      chrome.runtime.sendMessage({ action: "close_current_tab" });
      chrome.storage.local.set({ runningOneStatus: "skipped" });
      return;
    }
  }
  if (config.token) {
    try {
      const mapEl = document.querySelector(".js-open-map");
      if (mapEl) {
        const dataLat = mapEl.getAttribute("data-lat");
        if (dataLat) {
          const latLng = dataLat.split(",");
          if (latLng.length === 2) {
            const jobLng = parseFloat(latLng[0]);
            const jobLat = parseFloat(latLng[1]);
            if (!isNaN(jobLat) && !isNaN(jobLng)) {
              console.log("[Boss插件] 职位经纬度:", jobLat, jobLng);
              const distanceRes = await http.get(`/deliveryConfig/checkDistance?lat=${jobLat}&lng=${jobLng}`);
              console.log("[Boss插件] 距离检查结果:", distanceRes, "data类型:", typeof distanceRes.data, "data值:", distanceRes.data);
              if (distanceRes.code === 200 && (distanceRes.data === false || distanceRes.data === "false" || distanceRes.data === 0)) {
                console.log("[Boss插件] 职位距离超出设定范围，跳过此职位");
                chrome.runtime.sendMessage({ action: "close_current_tab" });
                chrome.storage.local.set({ runningOneStatus: "skipped" });
                return;
              }
            }
          }
        }
      }
    } catch (err) {
      console.warn("[Boss插件] 距离检查失败，继续投递:", err);
    }
  }
  const jobInfo = extractJobInfo();
  console.log("[Boss插件] 提取到的职位信息:", jobInfo);
  try {
    const res = await http.post("/deliveryHistory/save", jobInfo);
    if (res.code === 200 || res.code === 0) {
      currentHistoryId = res.data;
      chrome.storage.local.set({ lastHistoryId: currentHistoryId });
      console.log("[Boss插件] 职位信息预保存成功，ID:", currentHistoryId);
    }
  } catch (err) {
    console.error("[Boss插件] 职位信息预保存失败:", err);
  }
  if (autoReplyEnabled) {
    const aiConfig = await chrome.storage.local.get(["isAiEnabled", "aiCustomPrompt"]);
    const isAiEnabled = aiConfig.isAiEnabled == 1 || aiConfig.isAiEnabled === true || aiConfig.isAiEnabled === "true";
    const aiCustomPrompt = aiConfig.aiCustomPrompt || "";
    console.log("[Boss插件] AI 增强配置:", aiConfig.isAiEnabled, "是否启用:", isAiEnabled, "自定义Prompt:", aiCustomPrompt);
    if (isAiEnabled) {
      console.log("[Boss插件] 检测到开启了 AI 智能增强，正在生成个性化打招呼语...");
      try {
        const aiRes = await http.post("/ai/greeting", {
          jobTitle: jobInfo.jobTitle,
          jobDescription: jobInfo.jobDescription,
          templateContent: text,
          publisherName: jobInfo.publisher,
          companyName: jobInfo.companyName,
          aiCustomPrompt
        });
        console.log("[Boss插件] AI 接口返回:", aiRes);
        if ((aiRes.code === 200 || aiRes.code === "200" || aiRes.code === 0) && aiRes.data) {
          text = aiRes.data;
          await chrome.storage.local.set({ aiGeneratedText: text });
          console.log("[Boss插件] AI 生成成功，已更新打招呼语:", text);
        } else {
          console.warn("[Boss插件] AI 生成失败，使用默认模板:", aiRes.msg);
        }
      } catch (err) {
        console.error("[Boss插件] 调用 AI 接口异常:", err);
      }
    } else {
      var bossNameElement = document.querySelector(".job-boss-info h2.name");
      if (!bossNameElement) {
        bossNameElement = document.querySelector(".boss-info-name .name") || document.querySelector("h2.name") || document.querySelector(".name");
      }
      if (bossNameElement) {
        var bossNameText = "";
        for (var i = 0; i < bossNameElement.childNodes.length; i++) {
          var node = bossNameElement.childNodes[i];
          if (node.nodeType === Node.TEXT_NODE) {
            bossNameText = node.textContent.trim();
            if (bossNameText) break;
          }
        }
        if (!bossNameText) bossNameText = bossNameElement.textContent.trim();
        if (bossNameText) {
          var surname = bossNameText.charAt(0);
          text = surname + "老师，" + text;
        }
      }
    }
  }
  console.log("[Boss插件] 找到沟通按钮:", chatBtn);
  console.log("[Boss插件] 点击沟通按钮");
  chatBtn.click();
  if (autoReplyEnabled) {
    observePopup();
  } else {
    console.log("[Boss插件] 自动打招呼已关闭，点击沟通后直接关闭页面");
    await finishDelivery();
  }
}
function observePopup() {
  const observer = new MutationObserver((mutations) => {
    mutations.forEach((mutation) => {
      if (mutation.type === "childList") {
        const popupBtn = document.querySelector(".btn.btn-sure");
        if (popupBtn && popupBtn.innerHTML === "确定") {
          chrome.storage.local.set({ isRunning: false });
          return;
        }
        if (popupBtn) {
          popupBtn.click();
          observer.disconnect();
        }
      }
    });
    const chatInput = document.querySelector(".input-area") || document.querySelector(".chat-input");
    const sendButton = document.querySelector(".send-message") || document.querySelector(".btn-send");
    if (chatInput && sendButton) {
      setTimeout(async () => {
        const storage = await chrome.storage.local.get("aiGeneratedText");
        const messageToSend = storage.aiGeneratedText || text;
        console.log("[Boss插件] 准备发送的消息:", messageToSend);
        if (storage.aiGeneratedText) {
          chrome.storage.local.remove("aiGeneratedText");
        }
        if (chatInput.tagName === "DIV") {
          chatInput.innerHTML = messageToSend;
        } else {
          chatInput.value = messageToSend;
        }
        chatInput.dispatchEvent(new Event("input", { bubbles: true }));
        setTimeout(async () => {
          sendButton.click();
          await finishDelivery();
        }, 300);
      }, 200);
      observer.disconnect();
    }
  });
  const config = { childList: true, subtree: true };
  observer.observe(document.body, config);
}
async function finishDelivery() {
  return new Promise((resolve) => {
    chrome.storage.local.get("lastHistoryId", async (res) => {
      const historyId = currentHistoryId || res.lastHistoryId;
      if (historyId) {
        try {
          await http.post("/deliveryHistory/updateStatus", {
            historyId,
            status: "sent"
          });
          console.log("[Boss插件] 投递状态更新为 sent");
          chrome.storage.local.remove("lastHistoryId");
        } catch (err) {
          console.error("[Boss插件] 投递状态更新失败:", err);
        }
      }
      setTimeout(() => {
        chrome.storage.local.set({ runningOneStatus: "done" });
        chrome.runtime.sendMessage({ action: "close_current_tab" });
        resolve();
      }, 500);
    });
  });
}
