import { _ as _export_sfc, h as http, b as baseUrl, w as wsUrl } from "./chunks/plugin-vue-export-helper.js";
import { E as watch, D as onMounted, Z as resolveDirective, o as openBlock, l as createElementBlock, m as createBaseVNode, s as createVNode, u as unref, I as createCommentVNode, v as withDirectives, S as vModelText, z as createTextVNode, K as Fragment, W as renderList, A as toDisplayString, V as vModelSelect, y as normalizeClass, r as ref, c as computed, X as withKeys, H as createBlock, L as withModifiers, R as resolveComponent, U as vModelCheckbox, t as withCtx, Q as onUnmounted, N as nextTick, Y as createApp } from "./chunks/vue-vendor.js";
import { a as lock_default, s as search_default, b as download_default, c as delete_default, e as document_default, E as ElMessage, v as view_default, f as plus_default, o as office_building_default, g as close_default, m as magic_stick_default, w as warning_default, h as check_default, t as trend_charts_default, i as edit_default, j as copy_document_default, l as location_default, k as ticket_default, u as user_default, n as key_default, q as share_default, r as calendar_default, x as setting_default, y as circle_close_default } from "./chunks/element-plus.js";
import "./chunks/vendor.js";
const _hoisted_1$7 = {
  key: 0,
  class: "history-lock-overlay"
};
const _hoisted_2$7 = { class: "lock-card" };
const _hoisted_3$7 = { class: "lock-icon-wrap" };
const _hoisted_4$7 = { class: "section-header" };
const _hoisted_5$7 = { class: "actions" };
const _hoisted_6$7 = { class: "search-box" };
const _hoisted_7$7 = {
  key: 1,
  class: "history-table-wrap"
};
const _hoisted_8$5 = { class: "history-table" };
const _hoisted_9$4 = ["href"];
const _hoisted_10$4 = ["title"];
const _hoisted_11$4 = ["title"];
const _hoisted_12$4 = { class: "salary-cell" };
const _hoisted_13$4 = { class: "time-cell" };
const _hoisted_14$4 = { class: "action-cell" };
const _hoisted_15$4 = ["href"];
const _hoisted_16$4 = ["onClick"];
const _hoisted_17$4 = {
  key: 2,
  class: "empty-state"
};
const _hoisted_18$4 = { class: "empty-icon" };
const _hoisted_19$4 = {
  key: 3,
  class: "custom-pagination"
};
const _hoisted_20$4 = { class: "pagination-total" };
const _hoisted_21$4 = { class: "pagination-sizes" };
const _hoisted_22$4 = { class: "pagination-pager" };
const _hoisted_23$4 = ["disabled"];
const _hoisted_24$3 = { class: "pager-info" };
const _hoisted_25$3 = ["max"];
const _hoisted_26$3 = ["disabled"];
const _sfc_main$7 = {
  __name: "HistoryTab",
  props: {
    stats: {
      type: Object,
      default: () => ({})
    },
    userInfo: {
      type: Object,
      default: null
    }
  },
  emits: ["calculateStats", "switchTab"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const isPremium = computed(() => {
      var _a;
      return ((_a = props.userInfo) == null ? void 0 : _a.isPremium) === 1;
    });
    const emit = __emit;
    const historyList = ref([]);
    const totalCount = ref(0);
    const loading = ref(false);
    const searchKeyword = ref("");
    const currentPage = ref(1);
    const pageSize = ref(10);
    const fetchHistory = async () => {
      if (!isPremium.value) return;
      loading.value = true;
      try {
        const res = await http.get("/deliveryHistory/list", {
          page: currentPage.value,
          limit: pageSize.value,
          keyword: searchKeyword.value
        });
        if (res.code === 200 && res.data) {
          historyList.value = res.data || [];
          totalCount.value = res.total || 0;
        }
      } catch (err) {
        console.error("获取投递历史失败:", err);
        ElMessage.error("获取投递历史失败");
      } finally {
        loading.value = false;
      }
    };
    watch(searchKeyword, () => {
      currentPage.value = 1;
      fetchHistory();
    });
    watch(currentPage, () => {
      fetchHistory();
    });
    onMounted(() => {
      fetchHistory();
    });
    __expose({ refresh: fetchHistory });
    const clearHistory = async () => {
      try {
        if (!confirm("确定要清空所有投递记录吗？此操作不可恢复。")) {
          return;
        }
        const res = await http.delete("/deliveryHistory/clear");
        if (res.code === 200) {
          ElMessage.success("已清空历史记录");
          fetchHistory();
          emit("calculateStats");
        } else {
          ElMessage.error(res.msg || "清空失败");
        }
      } catch (err) {
        console.error("清空历史记录失败:", err);
        ElMessage.error("清空失败");
      }
    };
    const exportHistory = async () => {
      try {
        const token = await new Promise((resolve) => {
          chrome.storage.local.get(["token"], (res) => resolve(res.token || ""));
        });
        if (!token) {
          ElMessage.error("请先登录再进行导出");
          return;
        }
        const url = `${baseUrl}/deliveryHistory/export?keyword=${encodeURIComponent(searchKeyword.value)}`;
        ElMessage.info("正在准备导出，请稍候...");
        fetch(url, {
          method: "GET",
          headers: {
            "Authorization": token
          }
        }).then((response) => {
          if (!response.ok) throw new Error("导出失败");
          return response.blob();
        }).then((blob) => {
          const downloadUrl = window.URL.createObjectURL(blob);
          const a = document.createElement("a");
          a.href = downloadUrl;
          a.download = `Boss投递历史_${(/* @__PURE__ */ new Date()).getTime()}.xlsx`;
          document.body.appendChild(a);
          a.click();
          window.URL.revokeObjectURL(downloadUrl);
          document.body.removeChild(a);
          ElMessage.success("导出成功");
        }).catch((err) => {
          console.error("导出出错:", err);
          ElMessage.error("导出失败，请重试");
        });
      } catch (err) {
        console.error("导出准备失败:", err);
      }
    };
    const deleteRecord = async (record) => {
      try {
        if (!confirm(`确定要删除对“${record.companyName}”的投递记录吗？`)) {
          return;
        }
        const res = await http.delete(`/deliveryHistory/delete/${record.historyId}`);
        if (res.code === 200) {
          ElMessage.success("删除成功");
          fetchHistory();
          emit("calculateStats");
        } else {
          ElMessage.error(res.msg || "删除失败");
        }
      } catch (err) {
        console.error("删除记录失败:", err);
        ElMessage.error("删除失败");
      }
    };
    const formatTime = (timeStr) => {
      if (!timeStr) return "-";
      const date = new Date(timeStr);
      return date.toLocaleString("zh-CN", {
        year: "numeric",
        month: "2-digit",
        day: "2-digit",
        hour: "2-digit",
        minute: "2-digit"
      });
    };
    const handleCurrentChange = (val) => {
      currentPage.value = val;
      fetchHistory();
    };
    const handleSizeChange = (val) => {
      pageSize.value = val;
      currentPage.value = 1;
      fetchHistory();
    };
    return (_ctx, _cache) => {
      const _directive_loading = resolveDirective("loading");
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["tab-pane", { "locked-history": !isPremium.value }])
      }, [
        !isPremium.value ? (openBlock(), createElementBlock("div", _hoisted_1$7, [
          createBaseVNode("div", _hoisted_2$7, [
            createBaseVNode("div", _hoisted_3$7, [
              createVNode(unref(lock_default), { class: "el-icon-xl" })
            ]),
            _cache[9] || (_cache[9] = createBaseVNode("h3", null, "投递历史记录已锁定", -1)),
            _cache[10] || (_cache[10] = createBaseVNode("p", null, "详细记录、导出报表及智能分析为全功能版专享", -1)),
            _cache[11] || (_cache[11] = createBaseVNode("div", { class: "benefit-list" }, [
              createBaseVNode("div", { class: "benefit-item" }, "✨ 查看所有已投递职位的详细状态"),
              createBaseVNode("div", { class: "benefit-item" }, "✨ 支持导出 Excel 报表到本地"),
              createBaseVNode("div", { class: "benefit-item" }, "✨ 持续同步并保留终身投递数据")
            ], -1)),
            createBaseVNode("button", {
              class: "btn-primary-sm",
              onClick: _cache[0] || (_cache[0] = ($event) => emit("switchTab", "vip"))
            }, "立即解锁全功能版")
          ])
        ])) : createCommentVNode("", true),
        createBaseVNode("div", _hoisted_4$7, [
          _cache[14] || (_cache[14] = createBaseVNode("h2", null, "投递历史", -1)),
          createBaseVNode("div", _hoisted_5$7, [
            createBaseVNode("div", _hoisted_6$7, [
              withDirectives(createBaseVNode("input", {
                type: "text",
                "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => searchKeyword.value = $event),
                placeholder: "搜索职位或公司...",
                onInput: _cache[2] || (_cache[2] = ($event) => currentPage.value = 1)
              }, null, 544), [
                [vModelText, searchKeyword.value]
              ]),
              createVNode(unref(search_default), { class: "search-icon el-icon" })
            ]),
            createBaseVNode("button", {
              class: "btn-secondary",
              onClick: exportHistory
            }, [
              createVNode(unref(download_default), { class: "el-icon" }),
              _cache[12] || (_cache[12] = createTextVNode(" 导出 ", -1))
            ]),
            createBaseVNode("button", {
              class: "btn-danger",
              onClick: clearHistory
            }, [
              createVNode(unref(delete_default), { class: "el-icon" }),
              _cache[13] || (_cache[13] = createTextVNode(" 清空 ", -1))
            ])
          ])
        ]),
        historyList.value.length > 0 ? withDirectives((openBlock(), createElementBlock("div", _hoisted_7$7, [
          createBaseVNode("table", _hoisted_8$5, [
            _cache[15] || (_cache[15] = createBaseVNode("thead", null, [
              createBaseVNode("tr", null, [
                createBaseVNode("th", null, "职位信息"),
                createBaseVNode("th", null, "公司名称"),
                createBaseVNode("th", null, "薪资"),
                createBaseVNode("th", null, "时间"),
                createBaseVNode("th", null, "状态"),
                createBaseVNode("th", null, "操作")
              ])
            ], -1)),
            createBaseVNode("tbody", null, [
              (openBlock(true), createElementBlock(Fragment, null, renderList(historyList.value, (item, index) => {
                return openBlock(), createElementBlock("tr", {
                  key: item.historyId
                }, [
                  createBaseVNode("td", null, [
                    createBaseVNode("a", {
                      href: item.jobUrl,
                      target: "_blank",
                      class: "job-link",
                      title: "点击查看职位详情"
                    }, [
                      createBaseVNode("div", {
                        class: "job-cell",
                        title: item.jobTitle
                      }, toDisplayString(item.jobTitle), 9, _hoisted_10$4)
                    ], 8, _hoisted_9$4)
                  ]),
                  createBaseVNode("td", null, [
                    createBaseVNode("div", {
                      class: "company-cell",
                      title: item.companyFullName
                    }, toDisplayString(item.companyFullName), 9, _hoisted_11$4)
                  ]),
                  createBaseVNode("td", null, [
                    createBaseVNode("span", _hoisted_12$4, toDisplayString(item.salaryRange), 1)
                  ]),
                  createBaseVNode("td", null, [
                    createBaseVNode("span", _hoisted_13$4, toDisplayString(formatTime(item.deliveryTime)), 1)
                  ]),
                  createBaseVNode("td", null, [
                    createBaseVNode("span", {
                      class: normalizeClass(["status-tag", item.status])
                    }, toDisplayString(item.status === "sent" ? "已发送" : item.status === "wait" ? "等待中" : item.status), 3)
                  ]),
                  createBaseVNode("td", _hoisted_14$4, [
                    createBaseVNode("a", {
                      href: item.jobUrl,
                      target: "_blank",
                      class: "btn-icon-sm",
                      title: "查看详情"
                    }, [
                      createVNode(unref(view_default), { class: "el-icon" })
                    ], 8, _hoisted_15$4),
                    createBaseVNode("button", {
                      class: "btn-icon-sm",
                      onClick: ($event) => deleteRecord(item),
                      title: "删除"
                    }, [
                      createVNode(unref(delete_default), { class: "el-icon" })
                    ], 8, _hoisted_16$4)
                  ])
                ]);
              }), 128))
            ])
          ])
        ])), [
          [_directive_loading, loading.value]
        ]) : !loading.value ? (openBlock(), createElementBlock("div", _hoisted_17$4, [
          createBaseVNode("div", _hoisted_18$4, [
            createVNode(unref(document_default), { class: "el-icon-xl" })
          ]),
          _cache[16] || (_cache[16] = createBaseVNode("p", null, "暂无投递记录", -1)),
          _cache[17] || (_cache[17] = createBaseVNode("span", null, "开启自动投递后，记录将显示在这里", -1))
        ])) : createCommentVNode("", true),
        totalCount.value > 0 ? (openBlock(), createElementBlock("div", _hoisted_19$4, [
          createBaseVNode("div", _hoisted_20$4, "共 " + toDisplayString(totalCount.value) + " 条", 1),
          createBaseVNode("div", _hoisted_21$4, [
            withDirectives(createBaseVNode("select", {
              "onUpdate:modelValue": _cache[3] || (_cache[3] = ($event) => pageSize.value = $event),
              onChange: _cache[4] || (_cache[4] = ($event) => handleSizeChange($event.target.value))
            }, [..._cache[18] || (_cache[18] = [
              createBaseVNode("option", { value: 10 }, "10条/页", -1),
              createBaseVNode("option", { value: 20 }, "20条/页", -1),
              createBaseVNode("option", { value: 50 }, "50条/页", -1),
              createBaseVNode("option", { value: 100 }, "100条/页", -1)
            ])], 544), [
              [vModelSelect, pageSize.value]
            ])
          ]),
          createBaseVNode("div", _hoisted_22$4, [
            createBaseVNode("button", {
              class: "pager-btn",
              disabled: currentPage.value === 1,
              onClick: _cache[5] || (_cache[5] = ($event) => handleCurrentChange(currentPage.value - 1))
            }, " < ", 8, _hoisted_23$4),
            createBaseVNode("span", _hoisted_24$3, [
              _cache[19] || (_cache[19] = createTextVNode(" 第 ", -1)),
              withDirectives(createBaseVNode("input", {
                type: "number",
                "onUpdate:modelValue": _cache[6] || (_cache[6] = ($event) => currentPage.value = $event),
                onChange: _cache[7] || (_cache[7] = ($event) => handleCurrentChange(currentPage.value)),
                min: "1",
                max: Math.ceil(totalCount.value / pageSize.value)
              }, null, 40, _hoisted_25$3), [
                [
                  vModelText,
                  currentPage.value,
                  void 0,
                  { number: true }
                ]
              ]),
              createTextVNode(" 页 / " + toDisplayString(Math.ceil(totalCount.value / pageSize.value)) + " 页 ", 1)
            ]),
            createBaseVNode("button", {
              class: "pager-btn",
              disabled: currentPage.value >= Math.ceil(totalCount.value / pageSize.value),
              onClick: _cache[8] || (_cache[8] = ($event) => handleCurrentChange(currentPage.value + 1))
            }, " > ", 8, _hoisted_26$3)
          ])
        ])) : createCommentVNode("", true)
      ], 2);
    };
  }
};
const HistoryTab = /* @__PURE__ */ _export_sfc(_sfc_main$7, [["__scopeId", "data-v-da7fed88"]]);
const _hoisted_1$6 = { class: "tab-pane" };
const _hoisted_2$6 = { class: "section-header" };
const _hoisted_3$6 = { class: "actions" };
const _hoisted_4$6 = { class: "input-row" };
const _hoisted_5$6 = {
  key: 0,
  class: "list-container"
};
const _hoisted_6$6 = { class: "item-content" };
const _hoisted_7$6 = ["onClick"];
const _hoisted_8$4 = {
  key: 1,
  class: "empty-state-sm"
};
const _sfc_main$6 = {
  __name: "CompanyTab",
  props: {
    filterCompany: {
      type: Array,
      default: () => []
    },
    token: {
      type: String,
      default: ""
    }
  },
  emits: ["update:filterCompany"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const newCompany = ref("");
    const loadData = () => {
      if (!props.token) return;
      http.get("/filterRule/list?type=3").then((res) => {
        const companies = (res.data || []).map((i) => i.ruleValue);
        emit("update:filterCompany", companies);
        chrome.storage.local.set({ filterCompany: companies });
      });
    };
    const addCompany = () => {
      const val = newCompany.value.trim();
      if (val && !props.filterCompany.includes(val)) {
        http.post("/filterRule/add", { ruleType: 3, ruleValue: val }).then((res) => {
          if (res.code === 200) {
            newCompany.value = "";
            loadData();
          }
        });
      }
    };
    const removeCompany = (company) => {
      http.delete(`/filterRule/deleteByValue?type=3&value=${encodeURIComponent(company)}`).then((res) => {
        if (res.code === 200) {
          loadData();
        }
      });
    };
    const clearAllCompanies = () => {
      if (confirm("确定要清空所有拉黑公司吗？")) {
        http.delete("/filterRule/clear?type=3").then((res) => {
          if (res.code === 200) {
            loadData();
          }
        });
      }
    };
    onMounted(() => {
      loadData();
    });
    watch(() => props.token, (newVal) => {
      if (newVal) {
        loadData();
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$6, [
        createBaseVNode("div", _hoisted_2$6, [
          _cache[2] || (_cache[2] = createBaseVNode("h2", null, "拉黑公司名单", -1)),
          createBaseVNode("div", _hoisted_3$6, [
            __props.filterCompany.length ? (openBlock(), createElementBlock("button", {
              key: 0,
              class: "btn-danger",
              onClick: clearAllCompanies
            }, [
              createVNode(unref(delete_default), { class: "el-icon" }),
              _cache[1] || (_cache[1] = createTextVNode(" 清空全部 ", -1))
            ])) : createCommentVNode("", true)
          ])
        ]),
        _cache[5] || (_cache[5] = createBaseVNode("p", { class: "section-desc" }, "被拉黑的公司，系统在自动投递时会自动跳过（支持模糊匹配）", -1)),
        createBaseVNode("div", _hoisted_4$6, [
          withDirectives(createBaseVNode("input", {
            type: "text",
            "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => newCompany.value = $event),
            placeholder: "输入公司名称...",
            onKeyup: withKeys(addCompany, ["enter"])
          }, null, 544), [
            [vModelText, newCompany.value]
          ]),
          createBaseVNode("button", {
            class: "btn-primary-sm",
            onClick: addCompany
          }, [
            createVNode(unref(plus_default), { class: "el-icon" }),
            _cache[3] || (_cache[3] = createTextVNode(" 添加 ", -1))
          ])
        ]),
        __props.filterCompany.length > 0 ? (openBlock(), createElementBlock("div", _hoisted_5$6, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(__props.filterCompany, (company, index) => {
            return openBlock(), createElementBlock("div", {
              class: "list-item",
              key: index
            }, [
              createBaseVNode("div", _hoisted_6$6, [
                createVNode(unref(office_building_default), { class: "item-icon" }),
                createBaseVNode("span", null, toDisplayString(company), 1)
              ]),
              createBaseVNode("button", {
                class: "tag-close",
                onClick: ($event) => removeCompany(company)
              }, "×", 8, _hoisted_7$6)
            ]);
          }), 128))
        ])) : (openBlock(), createElementBlock("div", _hoisted_8$4, [..._cache[4] || (_cache[4] = [
          createBaseVNode("p", null, "暂无拉黑公司", -1)
        ])]))
      ]);
    };
  }
};
const CompanyTab = /* @__PURE__ */ _export_sfc(_sfc_main$6, [["__scopeId", "data-v-6de8b2b0"]]);
const _hoisted_1$5 = { class: "tab-pane" };
const _hoisted_2$5 = { class: "section-header" };
const _hoisted_3$5 = { class: "actions" };
const _hoisted_4$5 = { class: "input-row" };
const _hoisted_5$5 = {
  key: 0,
  class: "tag-container"
};
const _hoisted_6$5 = ["onClick"];
const _hoisted_7$5 = {
  key: 1,
  class: "empty-state-sm"
};
const _sfc_main$5 = {
  __name: "BlacklistTab",
  props: {
    blacklistKeywords: {
      type: Array,
      default: () => []
    },
    token: {
      type: String,
      default: ""
    }
  },
  emits: ["update:blacklistKeywords"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const newBlackKeyword = ref("");
    const loadData = () => {
      if (!props.token) return;
      http.get("/filterRule/list?type=1").then((res) => {
        const keywords = (res.data || []).map((i) => i.ruleValue);
        emit("update:blacklistKeywords", keywords);
        chrome.storage.local.set({ blacklistKeywords: keywords });
      });
    };
    const addBlackKeyword = () => {
      const val = newBlackKeyword.value.trim();
      if (val && !props.blacklistKeywords.includes(val)) {
        http.post("/filterRule/add", { ruleType: 1, ruleValue: val }).then((res) => {
          if (res.code === 200) {
            newBlackKeyword.value = "";
            loadData();
          } else {
            console.error("添加失败:", res.msg);
          }
        });
      }
    };
    const removeBlackKeyword = (keyword) => {
      http.delete(`/filterRule/deleteByValue?type=1&value=${encodeURIComponent(keyword)}`).then((res) => {
        if (res.code === 200) {
          loadData();
        }
      });
    };
    const clearAllBlackKeywords = () => {
      if (confirm("确定要清空所有黑名单关键词吗？")) {
        http.delete("/filterRule/clear?type=1").then((res) => {
          if (res.code === 200) {
            loadData();
          }
        });
      }
    };
    onMounted(() => {
      loadData();
    });
    watch(() => props.token, (newVal) => {
      if (newVal) {
        loadData();
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$5, [
        createBaseVNode("div", _hoisted_2$5, [
          _cache[2] || (_cache[2] = createBaseVNode("h2", null, "职位关键词黑名单", -1)),
          createBaseVNode("div", _hoisted_3$5, [
            __props.blacklistKeywords.length ? (openBlock(), createElementBlock("button", {
              key: 0,
              class: "btn-danger",
              onClick: clearAllBlackKeywords
            }, [
              createVNode(unref(delete_default), { class: "el-icon" }),
              _cache[1] || (_cache[1] = createTextVNode(" 清空全部 ", -1))
            ])) : createCommentVNode("", true)
          ])
        ]),
        _cache[5] || (_cache[5] = createBaseVNode("p", { class: "section-desc" }, "职位名称包含这些词的，系统会自动跳过不投递", -1)),
        createBaseVNode("div", _hoisted_4$5, [
          withDirectives(createBaseVNode("input", {
            type: "text",
            "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => newBlackKeyword.value = $event),
            placeholder: "如：外包、高级、架构师",
            onKeyup: withKeys(addBlackKeyword, ["enter"])
          }, null, 544), [
            [vModelText, newBlackKeyword.value]
          ]),
          createBaseVNode("button", {
            class: "btn-primary-sm",
            onClick: addBlackKeyword
          }, [
            createVNode(unref(plus_default), { class: "el-icon" }),
            _cache[3] || (_cache[3] = createTextVNode(" 添加 ", -1))
          ])
        ]),
        __props.blacklistKeywords.length > 0 ? (openBlock(), createElementBlock("div", _hoisted_5$5, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(__props.blacklistKeywords, (keyword, index) => {
            return openBlock(), createElementBlock("span", {
              class: "tag tag-primary",
              key: index
            }, [
              createTextVNode(toDisplayString(keyword) + " ", 1),
              createBaseVNode("button", {
                class: "tag-close",
                onClick: ($event) => removeBlackKeyword(keyword)
              }, "×", 8, _hoisted_6$5)
            ]);
          }), 128))
        ])) : (openBlock(), createElementBlock("div", _hoisted_7$5, [..._cache[4] || (_cache[4] = [
          createBaseVNode("p", null, "暂无黑名单关键词", -1)
        ])]))
      ]);
    };
  }
};
const BlacklistTab = /* @__PURE__ */ _export_sfc(_sfc_main$5, [["__scopeId", "data-v-8cee7454"]]);
const _hoisted_1$4 = { class: "tab-pane" };
const _hoisted_2$4 = { class: "section-header" };
const _hoisted_3$4 = { class: "actions" };
const _hoisted_4$4 = { class: "input-row" };
const _hoisted_5$4 = {
  key: 0,
  class: "tag-container"
};
const _hoisted_6$4 = ["onClick"];
const _hoisted_7$4 = {
  key: 1,
  class: "empty-state-sm"
};
const _sfc_main$4 = {
  __name: "WhitelistTab",
  props: {
    whitelistKeywords: {
      type: Array,
      default: () => []
    },
    token: {
      type: String,
      default: ""
    }
  },
  emits: ["update:whitelistKeywords"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const newWhiteKeyword = ref("");
    const loadData = () => {
      if (!props.token) return;
      http.get("/filterRule/list?type=2").then((res) => {
        const keywords = (res.data || []).map((i) => i.ruleValue);
        emit("update:whitelistKeywords", keywords);
        chrome.storage.local.set({ whitelistKeywords: keywords });
      });
    };
    const addWhiteKeyword = () => {
      const val = newWhiteKeyword.value.trim();
      if (val && !props.whitelistKeywords.includes(val)) {
        http.post("/filterRule/add", { ruleType: 2, ruleValue: val }).then((res) => {
          if (res.code === 200) {
            newWhiteKeyword.value = "";
            loadData();
          }
        });
      }
    };
    const removeWhiteKeyword = (keyword) => {
      http.delete(`/filterRule/deleteByValue?type=2&value=${encodeURIComponent(keyword)}`).then((res) => {
        if (res.code === 200) {
          loadData();
        }
      });
    };
    const clearAllWhiteKeywords = () => {
      if (confirm("确定要清空所有白名单关键词吗？")) {
        http.delete("/filterRule/clear?type=2").then((res) => {
          if (res.code === 200) {
            loadData();
          }
        });
      }
    };
    onMounted(() => {
      loadData();
    });
    watch(() => props.token, (newVal) => {
      if (newVal) {
        loadData();
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$4, [
        createBaseVNode("div", _hoisted_2$4, [
          _cache[2] || (_cache[2] = createBaseVNode("h2", null, "职位关键词白名单", -1)),
          createBaseVNode("div", _hoisted_3$4, [
            __props.whitelistKeywords.length ? (openBlock(), createElementBlock("button", {
              key: 0,
              class: "btn-danger",
              onClick: clearAllWhiteKeywords
            }, [
              createVNode(unref(delete_default), { class: "el-icon" }),
              _cache[1] || (_cache[1] = createTextVNode(" 清空全部 ", -1))
            ])) : createCommentVNode("", true)
          ])
        ]),
        _cache[5] || (_cache[5] = createBaseVNode("p", { class: "section-desc" }, "只投职位名称包含这些词的（留空则不限制）", -1)),
        createBaseVNode("div", _hoisted_4$4, [
          withDirectives(createBaseVNode("input", {
            type: "text",
            "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => newWhiteKeyword.value = $event),
            placeholder: "如：Java、后端、架构",
            onKeyup: withKeys(addWhiteKeyword, ["enter"])
          }, null, 544), [
            [vModelText, newWhiteKeyword.value]
          ]),
          createBaseVNode("button", {
            class: "btn-primary-sm",
            onClick: addWhiteKeyword
          }, [
            createVNode(unref(plus_default), { class: "el-icon" }),
            _cache[3] || (_cache[3] = createTextVNode(" 添加 ", -1))
          ])
        ]),
        __props.whitelistKeywords.length > 0 ? (openBlock(), createElementBlock("div", _hoisted_5$4, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(__props.whitelistKeywords, (keyword, index) => {
            return openBlock(), createElementBlock("span", {
              class: "tag tag-success",
              key: index
            }, [
              createTextVNode(toDisplayString(keyword) + " ", 1),
              createBaseVNode("button", {
                class: "tag-close",
                onClick: ($event) => removeWhiteKeyword(keyword)
              }, "×", 8, _hoisted_6$4)
            ]);
          }), 128))
        ])) : (openBlock(), createElementBlock("div", _hoisted_7$4, [..._cache[4] || (_cache[4] = [
          createBaseVNode("p", null, "暂无白名单关键词（不限制职位）", -1)
        ])]))
      ]);
    };
  }
};
const WhitelistTab = /* @__PURE__ */ _export_sfc(_sfc_main$4, [["__scopeId", "data-v-bf60c43a"]]);
const _hoisted_1$3 = { class: "tab-pane" };
const _hoisted_2$3 = { class: "section-header" };
const _hoisted_3$3 = { class: "actions" };
const _hoisted_4$3 = {
  key: 0,
  class: "add-template-form"
};
const _hoisted_5$3 = { class: "form-header" };
const _hoisted_6$3 = { class: "form-row" };
const _hoisted_7$3 = { class: "form-row" };
const _hoisted_8$3 = { class: "label-with-ai" };
const _hoisted_9$3 = ["disabled"];
const _hoisted_10$3 = {
  key: 1,
  class: "ai-loading-spinner"
};
const _hoisted_11$3 = { class: "form-row ai-switch-row" };
const _hoisted_12$3 = { class: "ai-label-wrap" };
const _hoisted_13$3 = {
  key: 0,
  class: "premium-tag-mini"
};
const _hoisted_14$3 = { class: "switch-text" };
const _hoisted_15$3 = { class: "ai-tip" };
const _hoisted_16$3 = {
  key: 0,
  class: "ai-warning"
};
const _hoisted_17$3 = {
  key: 0,
  class: "form-row"
};
const _hoisted_18$3 = { class: "label-with-ai" };
const _hoisted_19$3 = ["disabled"];
const _hoisted_20$3 = {
  key: 1,
  class: "ai-loading-spinner"
};
const _hoisted_21$3 = { class: "form-actions" };
const _hoisted_22$3 = {
  key: 1,
  class: "add-template-form editing"
};
const _hoisted_23$3 = { class: "form-header" };
const _hoisted_24$2 = { class: "form-row" };
const _hoisted_25$2 = { class: "form-row" };
const _hoisted_26$2 = { class: "label-with-ai" };
const _hoisted_27$1 = ["disabled"];
const _hoisted_28$1 = {
  key: 1,
  class: "ai-loading-spinner"
};
const _hoisted_29$1 = { class: "form-row ai-switch-row" };
const _hoisted_30$1 = { class: "ai-label-wrap" };
const _hoisted_31$1 = {
  key: 0,
  class: "premium-tag-mini"
};
const _hoisted_32$1 = { class: "switch-text" };
const _hoisted_33$1 = { class: "ai-tip" };
const _hoisted_34$1 = {
  key: 0,
  class: "ai-warning"
};
const _hoisted_35$1 = {
  key: 0,
  class: "form-row"
};
const _hoisted_36$1 = { class: "label-with-ai" };
const _hoisted_37$1 = ["disabled"];
const _hoisted_38$1 = {
  key: 1,
  class: "ai-loading-spinner"
};
const _hoisted_39$1 = {
  key: 2,
  class: "template-list"
};
const _hoisted_40$1 = ["onClick"];
const _hoisted_41$1 = {
  key: 0,
  class: "card-lock-overlay-icon"
};
const _hoisted_42$1 = { class: "template-card-header" };
const _hoisted_43 = { class: "template-info" };
const _hoisted_44 = { class: "template-name" };
const _hoisted_45 = {
  key: 0,
  class: "template-active-badge"
};
const _hoisted_46 = {
  key: 1,
  class: "template-ai-badge"
};
const _hoisted_47 = {
  key: 2,
  class: "template-locked-badge"
};
const _hoisted_48 = ["onClick"];
const _hoisted_49 = ["onClick"];
const _hoisted_50 = ["onClick"];
const _hoisted_51 = { class: "template-content" };
const _hoisted_52 = {
  key: 1,
  class: "template-select-hintOver"
};
const _hoisted_53 = {
  key: 2,
  class: "template-select-hint"
};
const _sfc_main$3 = {
  __name: "TemplateTab",
  props: {
    templates: {
      type: Array,
      default: () => []
    },
    activeTemplateId: {
      type: [Number, String],
      default: null
    },
    token: {
      type: String,
      default: ""
    },
    userInfo: {
      type: Object,
      default: null
    }
  },
  emits: ["update:templates", "update:activeTemplateId"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const editingTemplate = ref(null);
    const newTemplateName = ref("");
    const newTemplateContent = ref("");
    const newTemplateIsAi = ref(0);
    const newTemplateAiPrompt = ref("");
    const showAddTemplate = ref(false);
    const isAiWriting = ref(false);
    const isAiOptimizing = ref(false);
    const isPremium = computed(() => {
      var _a;
      return ((_a = props.userInfo) == null ? void 0 : _a.isPremium) === 1;
    });
    const handleAiWrite = (type = "new") => {
      if (!isPremium.value) {
        ElMessage.warning("AI 写作是高级版专享功能，请先升级会员");
        return;
      }
      const name = type === "new" ? newTemplateName.value : editingTemplate.value.name;
      const content = type === "new" ? newTemplateContent.value : editingTemplate.value.content;
      if (!name.trim()) {
        ElMessage.warning("请先填写模板名称，AI 将根据名称生成针对性内容");
        return;
      }
      isAiWriting.value = true;
      http.post("/ai/write-template", { name, content }).then((res) => {
        if (res.code === 200) {
          if (type === "new") {
            newTemplateContent.value = res.data;
          } else {
            editingTemplate.value.content = res.data;
          }
          ElMessage.success("AI 内容已生成");
        } else {
          ElMessage.error(res.msg || "生成失败");
        }
      }).finally(() => {
        isAiWriting.value = false;
      });
    };
    const handleAiOptimizePrompt = (type = "new") => {
      if (!isPremium.value) {
        ElMessage.warning("AI 优化是高级版专享功能，请先升级会员");
        return;
      }
      const prompt = type === "new" ? newTemplateAiPrompt.value : editingTemplate.value.aiCustomPrompt;
      if (!prompt.trim()) {
        ElMessage.warning("请先输入待优化的提示词内容");
        return;
      }
      isAiOptimizing.value = true;
      http.post("/ai/optimize-prompt", { prompt }).then((res) => {
        if (res.code === 200) {
          if (type === "new") {
            newTemplateAiPrompt.value = res.data;
          } else {
            editingTemplate.value.aiCustomPrompt = res.data;
          }
          ElMessage.success("提示词已优化");
        } else {
          ElMessage.error(res.msg || "优化失败");
        }
      }).finally(() => {
        isAiOptimizing.value = false;
      });
    };
    const loadData = () => {
      if (!props.token) return;
      http.get("/deliveryTemplate/list").then((res) => {
        if (res.code === 200 && res.data) {
          const remoteTemplates = res.data.map((t) => ({
            id: t.templateId,
            name: t.templateName,
            content: t.content,
            isDefault: t.isDefault,
            isAiEnabled: t.isAiEnabled || 0,
            aiCustomPrompt: t.aiCustomPrompt || ""
          }));
          emit("update:templates", remoteTemplates);
          chrome.storage.local.set({ templates: remoteTemplates });
          const defaultT = remoteTemplates.find((t) => t.isDefault === 1);
          if (defaultT) {
            emit("update:activeTemplateId", defaultT.id);
            chrome.storage.local.set({
              activeTemplateId: defaultT.id,
              text: defaultT.content,
              isAiEnabled: defaultT.isAiEnabled
            });
          }
        }
      });
    };
    const handleShowAdd = () => {
      if (!isPremium.value && props.templates.length >= 1) {
        ElMessage.warning("免费版用户最多只能添加 1 个模板，请升级高级版解锁限制");
        return;
      }
      showAddTemplate.value = true;
    };
    const selectTemplate = (template) => {
      if (template.id === props.activeTemplateId) return;
      if (!isPremium.value) {
        ElMessage.warning("多模板切换是高级版专享功能，请先升级会员");
        return;
      }
      http.post(`/deliveryTemplate/active/${template.id}`).then((res) => {
        if (res.code === 200) {
          emit("update:activeTemplateId", template.id);
          chrome.storage.local.set({
            activeTemplateId: template.id,
            text: template.content,
            isAiEnabled: template.isAiEnabled
          });
          loadData();
          ElMessage.success(`已切换到「${template.name}」`);
        } else {
          ElMessage.error(res.msg || "切换失败");
        }
      });
    };
    const addTemplate = () => {
      if (!isPremium.value && props.templates.length >= 1) {
        ElMessage.warning("如果您已过期，请保持模板数量为 1 个");
        return;
      }
      if (!newTemplateName.value.trim() || !newTemplateContent.value.trim()) {
        ElMessage.warning("请填写模板名称和内容");
        return;
      }
      const payload = {
        templateName: newTemplateName.value.trim(),
        content: newTemplateContent.value.trim(),
        isAiEnabled: newTemplateIsAi.value,
        aiCustomPrompt: newTemplateAiPrompt.value.trim()
      };
      http.post("/deliveryTemplate/add", payload).then((res) => {
        if (res.code === 200) {
          ElMessage.success("模板创建成功");
          newTemplateName.value = "";
          newTemplateContent.value = "";
          newTemplateIsAi.value = 0;
          newTemplateAiPrompt.value = "";
          showAddTemplate.value = false;
          loadData();
        } else {
          ElMessage.error(res.msg || "创建失败");
        }
      });
    };
    const startEditTemplate = (template) => {
      if (!isPremium.value && template.id !== props.activeTemplateId) {
        ElMessage.warning("多模板编辑是高级版专享功能，请先升级会员");
        return;
      }
      editingTemplate.value = { ...template };
    };
    const saveEditTemplate = () => {
      if (!editingTemplate.value) return;
      const payload = {
        templateId: editingTemplate.value.id,
        templateName: editingTemplate.value.name,
        content: editingTemplate.value.content,
        isAiEnabled: editingTemplate.value.isAiEnabled,
        aiCustomPrompt: editingTemplate.value.aiCustomPrompt
      };
      http.put("/deliveryTemplate/update", payload).then((res) => {
        if (res.code === 200) {
          ElMessage.success("模板修改成功");
          editingTemplate.value = null;
          loadData();
        } else {
          ElMessage.error(res.msg || "保存失败");
        }
      });
    };
    const cancelEditTemplate = () => {
      editingTemplate.value = null;
    };
    const deleteTemplate = (template) => {
      if (!isPremium.value && template.id !== props.activeTemplateId) {
        ElMessage.warning("多模板管理是高级版专享功能，请先升级会员");
        return;
      }
      if (template.isDefault === 1) {
        ElMessage.warning("不能删除正在使用的默认模板");
        return;
      }
      if (!confirm(`确定要删除模板「${template.name}」吗？`)) {
        return;
      }
      http.delete(`/deliveryTemplate/${template.id}`).then((res) => {
        if (res.code === 200) {
          ElMessage.success("模板已删除");
          loadData();
        } else {
          ElMessage.error(res.msg || "删除失败");
        }
      });
    };
    const duplicateTemplate = (template) => {
      if (!isPremium.value && props.templates.length >= 1) {
        ElMessage.warning("免费版用户最多只能添加 1 个模板");
        return;
      }
      const payload = {
        templateName: template.name + " (副本)",
        content: template.content,
        isAiEnabled: template.isAiEnabled,
        aiCustomPrompt: template.aiCustomPrompt
      };
      http.post("/deliveryTemplate/add", payload).then((res) => {
        if (res.code === 200) {
          ElMessage.success("副本创建成功");
          loadData();
        } else {
          ElMessage.error(res.msg || "复制失败");
        }
      });
    };
    onMounted(() => {
      loadData();
    });
    watch(() => props.token, (newVal) => {
      if (newVal) {
        loadData();
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$3, [
        createBaseVNode("div", _hoisted_2$3, [
          _cache[18] || (_cache[18] = createBaseVNode("h2", null, "打招呼模板管理", -1)),
          createBaseVNode("div", _hoisted_3$3, [
            !showAddTemplate.value && !editingTemplate.value ? (openBlock(), createElementBlock("button", {
              key: 0,
              class: "btn-primary-sm",
              onClick: handleShowAdd
            }, [
              createVNode(unref(plus_default), { class: "el-icon" }),
              _cache[17] || (_cache[17] = createTextVNode(" 新增模板 ", -1))
            ])) : createCommentVNode("", true)
          ])
        ]),
        _cache[41] || (_cache[41] = createBaseVNode("p", { class: "section-desc" }, '管理多个打招呼模板，选中的模板将用于自动投递。系统会自动添加"X老师，"在开头', -1)),
        showAddTemplate.value ? (openBlock(), createElementBlock("div", _hoisted_4$3, [
          createBaseVNode("div", _hoisted_5$3, [
            _cache[19] || (_cache[19] = createBaseVNode("h3", null, "创建新模板", -1)),
            createBaseVNode("button", {
              class: "btn-icon-sm",
              onClick: _cache[0] || (_cache[0] = ($event) => showAddTemplate.value = false)
            }, [
              createVNode(unref(close_default), { class: "el-icon" })
            ])
          ]),
          createBaseVNode("div", _hoisted_6$3, [
            _cache[20] || (_cache[20] = createBaseVNode("label", null, "模板名称", -1)),
            withDirectives(createBaseVNode("input", {
              "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => newTemplateName.value = $event),
              placeholder: "如：Java开发岗位、外企专用等"
            }, null, 512), [
              [vModelText, newTemplateName.value]
            ])
          ]),
          createBaseVNode("div", _hoisted_7$3, [
            createBaseVNode("div", _hoisted_8$3, [
              _cache[21] || (_cache[21] = createBaseVNode("label", null, "打招呼内容", -1)),
              createBaseVNode("button", {
                class: "btn-ai-mini",
                onClick: _cache[2] || (_cache[2] = ($event) => handleAiWrite("new")),
                disabled: isAiWriting.value
              }, [
                !isAiWriting.value ? (openBlock(), createBlock(unref(magic_stick_default), {
                  key: 0,
                  class: "el-icon-ai"
                })) : (openBlock(), createElementBlock("span", _hoisted_10$3)),
                createTextVNode(" " + toDisplayString(isAiWriting.value ? "生成中..." : "AI 帮我写"), 1)
              ], 8, _hoisted_9$3)
            ]),
            withDirectives(createBaseVNode("textarea", {
              "onUpdate:modelValue": _cache[3] || (_cache[3] = ($event) => newTemplateContent.value = $event),
              placeholder: "请输入打招呼内容...",
              rows: "5"
            }, null, 512), [
              [vModelText, newTemplateContent.value]
            ])
          ]),
          createBaseVNode("div", _hoisted_11$3, [
            createBaseVNode("div", _hoisted_12$3, [
              _cache[22] || (_cache[22] = createBaseVNode("label", null, "AI 智能增强", -1)),
              !isPremium.value ? (openBlock(), createElementBlock("span", _hoisted_13$3, "Premium")) : createCommentVNode("", true)
            ]),
            createBaseVNode("div", {
              class: "ai-switch-wrap",
              onClick: _cache[5] || (_cache[5] = ($event) => !isPremium.value ? unref(ElMessage).warning("AI 智能增强是高级版专享功能") : null)
            }, [
              createBaseVNode("button", {
                class: normalizeClass(["switch-btn", { active: newTemplateIsAi.value === 1, disabled: !isPremium.value }]),
                onClick: _cache[4] || (_cache[4] = withModifiers(($event) => isPremium.value ? newTemplateIsAi.value = newTemplateIsAi.value === 1 ? 0 : 1 : null, ["stop"]))
              }, [..._cache[23] || (_cache[23] = [
                createBaseVNode("div", { class: "switch-dot" }, null, -1)
              ])], 2),
              createBaseVNode("span", _hoisted_14$3, toDisplayString(newTemplateIsAi.value === 1 ? "已开启" : "已关闭"), 1)
            ]),
            createBaseVNode("p", _hoisted_15$3, [
              _cache[25] || (_cache[25] = createTextVNode(" 开启后，系统将根据职位描述自动解析并生成极具针对性的招呼语。 ", -1)),
              _cache[26] || (_cache[26] = createBaseVNode("br", null, null, -1)),
              newTemplateIsAi.value === 1 ? (openBlock(), createElementBlock("span", _hoisted_16$3, [
                createVNode(unref(warning_default), { class: "el-icon-warning" }),
                _cache[24] || (_cache[24] = createTextVNode(" 开启后 AI 分析需要 2-3 秒，投递响应会略有延迟。 ", -1))
              ])) : createCommentVNode("", true)
            ])
          ]),
          newTemplateIsAi.value === 1 ? (openBlock(), createElementBlock("div", _hoisted_17$3, [
            createBaseVNode("div", _hoisted_18$3, [
              _cache[27] || (_cache[27] = createBaseVNode("label", null, "AI 自定义提示词 (可选)", -1)),
              createBaseVNode("button", {
                class: "btn-ai-mini",
                onClick: _cache[6] || (_cache[6] = ($event) => handleAiOptimizePrompt("new")),
                disabled: isAiOptimizing.value
              }, [
                !isAiOptimizing.value ? (openBlock(), createBlock(unref(magic_stick_default), {
                  key: 0,
                  class: "el-icon-ai"
                })) : (openBlock(), createElementBlock("span", _hoisted_20$3)),
                createTextVNode(" " + toDisplayString(isAiOptimizing.value ? "优化中..." : "AI 优化"), 1)
              ], 8, _hoisted_19$3)
            ]),
            withDirectives(createBaseVNode("textarea", {
              "onUpdate:modelValue": _cache[7] || (_cache[7] = ($event) => newTemplateAiPrompt.value = $event),
              placeholder: "例如：重点突出我的分布式架构经验；语气要幽默一点；告诉招聘人我随时可以面试...",
              rows: "3"
            }, null, 512), [
              [vModelText, newTemplateAiPrompt.value]
            ]),
            _cache[28] || (_cache[28] = createBaseVNode("p", { class: "ai-input-hint" }, "我们会自动获取【招聘人姓名/职位】、【职位描述(JD)】、【投递岗位】提供给 AI，您可以在此处补充额外的叮嘱。", -1))
          ])) : createCommentVNode("", true),
          createBaseVNode("div", _hoisted_21$3, [
            createBaseVNode("button", {
              class: "btn-secondary-sm",
              onClick: _cache[8] || (_cache[8] = ($event) => showAddTemplate.value = false)
            }, "取消"),
            createBaseVNode("button", {
              class: "btn-primary-sm",
              onClick: addTemplate
            }, "创建模板")
          ])
        ])) : createCommentVNode("", true),
        editingTemplate.value ? (openBlock(), createElementBlock("div", _hoisted_22$3, [
          createBaseVNode("div", _hoisted_23$3, [
            createBaseVNode("h3", null, "编辑模板：" + toDisplayString(editingTemplate.value.name), 1),
            createBaseVNode("button", {
              class: "btn-icon-sm",
              onClick: cancelEditTemplate
            }, [
              createVNode(unref(close_default), { class: "el-icon" })
            ])
          ]),
          createBaseVNode("div", _hoisted_24$2, [
            _cache[29] || (_cache[29] = createBaseVNode("label", null, "模板名称", -1)),
            withDirectives(createBaseVNode("input", {
              "onUpdate:modelValue": _cache[9] || (_cache[9] = ($event) => editingTemplate.value.name = $event),
              placeholder: "模板名称"
            }, null, 512), [
              [vModelText, editingTemplate.value.name]
            ])
          ]),
          createBaseVNode("div", _hoisted_25$2, [
            createBaseVNode("div", _hoisted_26$2, [
              _cache[30] || (_cache[30] = createBaseVNode("label", null, "打招呼内容", -1)),
              createBaseVNode("button", {
                class: "btn-ai-mini",
                onClick: _cache[10] || (_cache[10] = ($event) => handleAiWrite("edit")),
                disabled: isAiWriting.value
              }, [
                !isAiWriting.value ? (openBlock(), createBlock(unref(magic_stick_default), {
                  key: 0,
                  class: "el-icon-ai"
                })) : (openBlock(), createElementBlock("span", _hoisted_28$1)),
                createTextVNode(" " + toDisplayString(isAiWriting.value ? "生成中..." : "AI 帮我写"), 1)
              ], 8, _hoisted_27$1)
            ]),
            withDirectives(createBaseVNode("textarea", {
              "onUpdate:modelValue": _cache[11] || (_cache[11] = ($event) => editingTemplate.value.content = $event),
              placeholder: "打招呼内容",
              rows: "5"
            }, null, 512), [
              [vModelText, editingTemplate.value.content]
            ])
          ]),
          createBaseVNode("div", _hoisted_29$1, [
            createBaseVNode("div", _hoisted_30$1, [
              _cache[31] || (_cache[31] = createBaseVNode("label", null, "AI 智能增强", -1)),
              !isPremium.value ? (openBlock(), createElementBlock("span", _hoisted_31$1, "Premium")) : createCommentVNode("", true)
            ]),
            createBaseVNode("div", {
              class: "ai-switch-wrap",
              onClick: _cache[13] || (_cache[13] = ($event) => !isPremium.value ? unref(ElMessage).warning("AI 智能增强是高级版专享功能") : null)
            }, [
              createBaseVNode("button", {
                class: normalizeClass(["switch-btn", { active: editingTemplate.value.isAiEnabled === 1, disabled: !isPremium.value }]),
                onClick: _cache[12] || (_cache[12] = withModifiers(($event) => isPremium.value ? editingTemplate.value.isAiEnabled = editingTemplate.value.isAiEnabled === 1 ? 0 : 1 : null, ["stop"]))
              }, [..._cache[32] || (_cache[32] = [
                createBaseVNode("div", { class: "switch-dot" }, null, -1)
              ])], 2),
              createBaseVNode("span", _hoisted_32$1, toDisplayString(editingTemplate.value.isAiEnabled === 1 ? "已开启" : "已关闭"), 1)
            ]),
            createBaseVNode("p", _hoisted_33$1, [
              _cache[34] || (_cache[34] = createTextVNode(" 开启后，系统将根据职位描述自动解析并生成极具针对性的招呼语。 ", -1)),
              _cache[35] || (_cache[35] = createBaseVNode("br", null, null, -1)),
              editingTemplate.value.isAiEnabled === 1 ? (openBlock(), createElementBlock("span", _hoisted_34$1, [
                createVNode(unref(warning_default), { class: "el-icon-warning" }),
                _cache[33] || (_cache[33] = createTextVNode(" 开启后 AI 分析需要 2-3 秒，投递响应会略有延迟。 ", -1))
              ])) : createCommentVNode("", true)
            ])
          ]),
          editingTemplate.value.isAiEnabled === 1 ? (openBlock(), createElementBlock("div", _hoisted_35$1, [
            createBaseVNode("div", _hoisted_36$1, [
              _cache[36] || (_cache[36] = createBaseVNode("label", null, "AI 自定义提示词 (可选)", -1)),
              createBaseVNode("button", {
                class: "btn-ai-mini",
                onClick: _cache[14] || (_cache[14] = ($event) => handleAiOptimizePrompt("edit")),
                disabled: isAiOptimizing.value
              }, [
                !isAiOptimizing.value ? (openBlock(), createBlock(unref(magic_stick_default), {
                  key: 0,
                  class: "el-icon-ai"
                })) : (openBlock(), createElementBlock("span", _hoisted_38$1)),
                createTextVNode(" " + toDisplayString(isAiOptimizing.value ? "优化中..." : "AI 优化"), 1)
              ], 8, _hoisted_37$1)
            ]),
            withDirectives(createBaseVNode("textarea", {
              "onUpdate:modelValue": _cache[15] || (_cache[15] = ($event) => editingTemplate.value.aiCustomPrompt = $event),
              placeholder: "补充您的个性化要求...",
              rows: "3"
            }, null, 512), [
              [vModelText, editingTemplate.value.aiCustomPrompt]
            ]),
            _cache[37] || (_cache[37] = createBaseVNode("p", { class: "ai-input-hint" }, "我们会自动获取【招聘人姓名/职位】、【职位描述(JD)】、【投递岗位】提供给 AI，您可以在此处补充额外的叮嘱。", -1))
          ])) : createCommentVNode("", true),
          createBaseVNode("div", { class: "form-actions" }, [
            createBaseVNode("button", {
              class: "btn-secondary-sm",
              onClick: cancelEditTemplate
            }, "取消"),
            createBaseVNode("button", {
              class: "btn-primary-sm",
              onClick: saveEditTemplate
            }, "保存修改")
          ])
        ])) : createCommentVNode("", true),
        !showAddTemplate.value && !editingTemplate.value ? (openBlock(), createElementBlock("div", _hoisted_39$1, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(__props.templates, (template) => {
            return openBlock(), createElementBlock("div", {
              key: template.id,
              class: normalizeClass(["template-card", {
                active: template.id === __props.activeTemplateId,
                locked: !isPremium.value && template.id !== __props.activeTemplateId
              }]),
              onClick: ($event) => selectTemplate(template)
            }, [
              !isPremium.value && template.id !== __props.activeTemplateId ? (openBlock(), createElementBlock("div", _hoisted_41$1, [
                createVNode(unref(lock_default))
              ])) : createCommentVNode("", true),
              createBaseVNode("div", _hoisted_42$1, [
                createBaseVNode("div", _hoisted_43, [
                  createBaseVNode("span", _hoisted_44, toDisplayString(template.name), 1),
                  template.id === __props.activeTemplateId ? (openBlock(), createElementBlock("span", _hoisted_45, [
                    createVNode(unref(check_default), { class: "el-icon-sm" }),
                    _cache[38] || (_cache[38] = createTextVNode(" 正在使用 ", -1))
                  ])) : createCommentVNode("", true),
                  template.isAiEnabled === 1 ? (openBlock(), createElementBlock("span", _hoisted_46, [
                    createVNode(unref(trend_charts_default), { class: "el-icon-sm" }),
                    _cache[39] || (_cache[39] = createTextVNode(" AI 增强中 ", -1))
                  ])) : createCommentVNode("", true),
                  !isPremium.value && template.id !== __props.activeTemplateId ? (openBlock(), createElementBlock("span", _hoisted_47, [
                    createVNode(unref(lock_default), { class: "el-icon-sm" }),
                    _cache[40] || (_cache[40] = createTextVNode(" 已锁定 ", -1))
                  ])) : createCommentVNode("", true)
                ]),
                createBaseVNode("div", {
                  class: "template-actions",
                  onClick: _cache[16] || (_cache[16] = withModifiers(() => {
                  }, ["stop"]))
                }, [
                  createBaseVNode("button", {
                    class: normalizeClass(["btn-icon-sm", { disabled: !isPremium.value && template.id !== __props.activeTemplateId }]),
                    onClick: ($event) => startEditTemplate(template),
                    title: "编辑"
                  }, [
                    createVNode(unref(edit_default), { class: "el-icon" })
                  ], 10, _hoisted_48),
                  createBaseVNode("button", {
                    class: normalizeClass(["btn-icon-sm", { disabled: !isPremium.value && template.id !== __props.activeTemplateId }]),
                    onClick: ($event) => duplicateTemplate(template),
                    title: "复制"
                  }, [
                    createVNode(unref(copy_document_default), { class: "el-icon" })
                  ], 10, _hoisted_49),
                  createBaseVNode("button", {
                    class: normalizeClass(["btn-icon-sm", { disabled: !isPremium.value && template.id !== __props.activeTemplateId }]),
                    onClick: ($event) => deleteTemplate(template),
                    title: "删除"
                  }, [
                    createVNode(unref(delete_default), { class: "el-icon" })
                  ], 10, _hoisted_50)
                ])
              ]),
              createBaseVNode("div", _hoisted_51, toDisplayString(template.content.length > 150 ? template.content.substring(0, 150) + "..." : template.content), 1),
              !isPremium.value && template.id !== __props.activeTemplateId ? (openBlock(), createElementBlock("div", _hoisted_52, " 升级高级版解锁此模板 ")) : template.id !== __props.activeTemplateId ? (openBlock(), createElementBlock("div", _hoisted_53, " 点击选择此模板 ")) : createCommentVNode("", true)
            ], 10, _hoisted_40$1);
          }), 128))
        ])) : createCommentVNode("", true)
      ]);
    };
  }
};
const TemplateTab = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["__scopeId", "data-v-a3b4c533"]]);
const _hoisted_1$2 = { class: "tab-pane" };
const _hoisted_2$2 = { class: "config-form" };
const _hoisted_3$2 = { class: "config-item" };
const _hoisted_4$2 = { class: "config-input" };
const _hoisted_5$2 = { class: "config-item" };
const _hoisted_6$2 = { class: "config-input range-input" };
const _hoisted_7$2 = { class: "config-item" };
const _hoisted_8$2 = { class: "config-input range-input" };
const _hoisted_9$2 = { class: "config-item" };
const _hoisted_10$2 = { class: "config-switch" };
const _hoisted_11$2 = { class: "switch" };
const _hoisted_12$2 = { class: "config-item" };
const _hoisted_13$2 = { class: "config-switch" };
const _hoisted_14$2 = { class: "switch" };
const _hoisted_15$2 = { class: "config-item" };
const _hoisted_16$2 = { class: "config-switch" };
const _hoisted_17$2 = { class: "switch" };
const _hoisted_18$2 = {
  class: "config-item location-item",
  style: { "grid-column": "1 / -1" }
};
const _hoisted_19$2 = { class: "location-controls" };
const _hoisted_20$2 = { class: "location-coords" };
const _hoisted_21$2 = {
  key: 0,
  class: "config-item"
};
const _hoisted_22$2 = { class: "config-switch" };
const _hoisted_23$2 = { class: "switch" };
const _hoisted_24$1 = {
  key: 1,
  class: "config-item"
};
const _hoisted_25$1 = { class: "config-input" };
const _hoisted_26$1 = ["disabled"];
const _sfc_main$2 = {
  __name: "ConfigTab",
  props: {
    deliveryConfig: {
      type: Object,
      default: () => ({
        deliveryCount: 100,
        salaryMin: 0,
        salaryMax: 0,
        onlyOnlineHr: 0,
        skipCommunicated: 0,
        autoReply: 0,
        delayMin: 10,
        delayMax: 30,
        userLongitude: null,
        userLatitude: null,
        userAddress: "",
        maxDistance: 0,
        enableDistanceFilter: 0
      })
    },
    token: {
      type: String,
      default: ""
    }
  },
  emits: ["update:deliveryConfig"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const validateDelays = () => {
      if (props.deliveryConfig.delayMin < 3) {
        props.deliveryConfig.delayMin = 3;
        ElMessage.warning("最短间隔不能低于 3 秒");
      }
      if (props.deliveryConfig.delayMax < props.deliveryConfig.delayMin) {
        props.deliveryConfig.delayMax = props.deliveryConfig.delayMin;
        ElMessage.warning("最大间隔不能小于最小间隔");
      }
      saveConfig(false);
    };
    const loadConfig = () => {
      if (!props.token) {
        chrome.storage.local.get("deliveryConfig", (res) => {
          if (res.deliveryConfig) {
            emit("update:deliveryConfig", res.deliveryConfig);
          }
        });
        return;
      }
      http.get("/deliveryConfig/info").then((res) => {
        if (res.data) {
          emit("update:deliveryConfig", res.data);
          chrome.storage.local.set({ deliveryConfig: res.data });
        }
      }).catch((err) => console.error("加载配置失败:", err));
    };
    let saveTimer = null;
    const saveConfig = (quiet = false) => {
      const cfg = props.deliveryConfig;
      cfg.deliveryCount = Number(cfg.deliveryCount) || 0;
      cfg.salaryMin = Number(cfg.salaryMin) || 0;
      cfg.salaryMax = Number(cfg.salaryMax) || 0;
      if (cfg.salaryMin > cfg.salaryMax) {
        cfg.salaryMax = cfg.salaryMin;
      }
      cfg.maxDistance = Number(cfg.maxDistance) || 0;
      cfg.userLongitude = cfg.userLongitude === null || cfg.userLongitude === "" ? 0 : Number(cfg.userLongitude);
      cfg.userLatitude = cfg.userLatitude === null || cfg.userLatitude === "" ? 0 : Number(cfg.userLatitude);
      cfg.delayMin = cfg.delayMin === null || cfg.delayMin === "" || Number(cfg.delayMin) < 3 ? 3 : Number(cfg.delayMin);
      cfg.delayMax = cfg.delayMax === null || cfg.delayMax === "" ? cfg.delayMin : Number(cfg.delayMax);
      if (cfg.delayMax < cfg.delayMin) {
        cfg.delayMax = cfg.delayMin;
      }
      chrome.storage.local.set({ deliveryConfig: cfg }, () => {
        if (!props.token) {
          if (!quiet) ElMessage.success("本地配置保存成功");
          return;
        }
        http.post("/deliveryConfig/sync", cfg).then((res) => {
          if (!quiet) {
            if (saveTimer) clearTimeout(saveTimer);
            saveTimer = setTimeout(() => {
              ElMessage.success("配置已自动同步到云端");
            }, 500);
          }
        }).catch((err) => {
          ElMessage.error("云端同步失败，已保存在本地");
          console.error(err);
        });
      });
    };
    const getCurrentLocation = () => {
      if (!navigator.geolocation) {
        ElMessage.error("您的浏览器不支持地理定位");
        return;
      }
      ElMessage.info("正在获取您的位置...");
      navigator.geolocation.getCurrentPosition(
        (position) => {
          props.deliveryConfig.userLongitude = position.coords.longitude.toFixed(7);
          props.deliveryConfig.userLatitude = position.coords.latitude.toFixed(7);
          props.deliveryConfig.userAddress = `${props.deliveryConfig.userLongitude}, ${props.deliveryConfig.userLatitude}`;
          ElMessage.success("位置获取成功");
          saveConfig(false);
        },
        (error) => {
          let errorMsg = "获取位置失败";
          switch (error.code) {
            case error.PERMISSION_DENIED:
              errorMsg = "您拒绝了位置权限请求";
              break;
            case error.POSITION_UNAVAILABLE:
              errorMsg = "位置信息不可用";
              break;
            case error.TIMEOUT:
              errorMsg = "获取位置超时";
              break;
          }
          ElMessage.error(errorMsg);
        },
        {
          enableHighAccuracy: true,
          timeout: 1e4,
          maximumAge: 0
        }
      );
    };
    onMounted(() => {
      loadConfig();
    });
    watch(() => props.token, (newVal) => {
      if (newVal) {
        loadConfig();
      }
    });
    __expose({ loadConfig });
    return (_ctx, _cache) => {
      const _component_el_icon = resolveComponent("el-icon");
      return openBlock(), createElementBlock("div", _hoisted_1$2, [
        _cache[40] || (_cache[40] = createBaseVNode("div", { class: "section-header" }, [
          createBaseVNode("h2", null, "基础投递配置")
        ], -1)),
        _cache[41] || (_cache[41] = createBaseVNode("p", { class: "section-desc" }, "配置自动投递时的全局过滤规则，修改后将同步到本地插件及后端云端存储", -1)),
        createBaseVNode("div", _hoisted_2$2, [
          createBaseVNode("div", _hoisted_3$2, [
            _cache[22] || (_cache[22] = createBaseVNode("div", { class: "config-label" }, [
              createBaseVNode("span", null, "投递数"),
              createBaseVNode("small", null, "系统当前执行的投递数量")
            ], -1)),
            createBaseVNode("div", _hoisted_4$2, [
              withDirectives(createBaseVNode("input", {
                type: "number",
                "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => __props.deliveryConfig.deliveryCount = $event),
                onChange: _cache[1] || (_cache[1] = ($event) => saveConfig(false))
              }, null, 544), [
                [vModelText, __props.deliveryConfig.deliveryCount]
              ])
            ])
          ]),
          createBaseVNode("div", _hoisted_5$2, [
            _cache[24] || (_cache[24] = createBaseVNode("div", { class: "config-label" }, [
              createBaseVNode("span", null, "间隔投递随机范围 (秒)"),
              createBaseVNode("small", null, "模拟真人行为，随机延迟一段时间再投递")
            ], -1)),
            createBaseVNode("div", _hoisted_6$2, [
              withDirectives(createBaseVNode("input", {
                type: "number",
                "onUpdate:modelValue": _cache[2] || (_cache[2] = ($event) => __props.deliveryConfig.delayMin = $event),
                min: "3",
                onChange: validateDelays,
                placeholder: "最小"
              }, null, 544), [
                [vModelText, __props.deliveryConfig.delayMin]
              ]),
              _cache[23] || (_cache[23] = createBaseVNode("span", { class: "separator" }, "-", -1)),
              withDirectives(createBaseVNode("input", {
                type: "number",
                "onUpdate:modelValue": _cache[3] || (_cache[3] = ($event) => __props.deliveryConfig.delayMax = $event),
                min: "3",
                onChange: validateDelays,
                placeholder: "最大"
              }, null, 544), [
                [vModelText, __props.deliveryConfig.delayMax]
              ])
            ])
          ]),
          createBaseVNode("div", _hoisted_7$2, [
            _cache[26] || (_cache[26] = createBaseVNode("div", { class: "config-label" }, [
              createBaseVNode("span", null, "期望薪资范围 (K)"),
              createBaseVNode("small", null, "设置 0 则不限制")
            ], -1)),
            createBaseVNode("div", _hoisted_8$2, [
              withDirectives(createBaseVNode("input", {
                type: "number",
                "onUpdate:modelValue": _cache[4] || (_cache[4] = ($event) => __props.deliveryConfig.salaryMin = $event),
                placeholder: "最小",
                onChange: _cache[5] || (_cache[5] = ($event) => saveConfig(false))
              }, null, 544), [
                [vModelText, __props.deliveryConfig.salaryMin]
              ]),
              _cache[25] || (_cache[25] = createBaseVNode("span", { class: "separator" }, "-", -1)),
              withDirectives(createBaseVNode("input", {
                type: "number",
                "onUpdate:modelValue": _cache[6] || (_cache[6] = ($event) => __props.deliveryConfig.salaryMax = $event),
                placeholder: "最大",
                onChange: _cache[7] || (_cache[7] = ($event) => saveConfig(false))
              }, null, 544), [
                [vModelText, __props.deliveryConfig.salaryMax]
              ])
            ])
          ]),
          createBaseVNode("div", _hoisted_9$2, [
            _cache[28] || (_cache[28] = createBaseVNode("div", { class: "config-label" }, [
              createBaseVNode("span", null, "强制要求 HR 在线"),
              createBaseVNode("small", null, "只投递当前在线（或活跃）的 HR 发布的职位")
            ], -1)),
            createBaseVNode("div", _hoisted_10$2, [
              createBaseVNode("label", _hoisted_11$2, [
                withDirectives(createBaseVNode("input", {
                  type: "checkbox",
                  "onUpdate:modelValue": _cache[8] || (_cache[8] = ($event) => __props.deliveryConfig.onlyOnlineHr = $event),
                  "true-value": 1,
                  "false-value": 0,
                  onChange: _cache[9] || (_cache[9] = ($event) => saveConfig(false))
                }, null, 544), [
                  [vModelCheckbox, __props.deliveryConfig.onlyOnlineHr]
                ]),
                _cache[27] || (_cache[27] = createBaseVNode("span", { class: "slider round" }, null, -1))
              ])
            ])
          ]),
          createBaseVNode("div", _hoisted_12$2, [
            _cache[30] || (_cache[30] = createBaseVNode("div", { class: "config-label" }, [
              createBaseVNode("span", null, "跳过曾经沟通的职位"),
              createBaseVNode("small", null, "不重复投递已经打过招呼或聊过的职位")
            ], -1)),
            createBaseVNode("div", _hoisted_13$2, [
              createBaseVNode("label", _hoisted_14$2, [
                withDirectives(createBaseVNode("input", {
                  type: "checkbox",
                  "onUpdate:modelValue": _cache[10] || (_cache[10] = ($event) => __props.deliveryConfig.skipCommunicated = $event),
                  "true-value": 1,
                  "false-value": 0,
                  onChange: _cache[11] || (_cache[11] = ($event) => saveConfig(false))
                }, null, 544), [
                  [vModelCheckbox, __props.deliveryConfig.skipCommunicated]
                ]),
                _cache[29] || (_cache[29] = createBaseVNode("span", { class: "slider round" }, null, -1))
              ])
            ])
          ]),
          createBaseVNode("div", _hoisted_15$2, [
            _cache[32] || (_cache[32] = createBaseVNode("div", { class: "config-label" }, [
              createBaseVNode("span", null, "打招呼模板"),
              createBaseVNode("small", null, "将投递的岗位中自动打招呼")
            ], -1)),
            createBaseVNode("div", _hoisted_16$2, [
              createBaseVNode("label", _hoisted_17$2, [
                withDirectives(createBaseVNode("input", {
                  type: "checkbox",
                  "onUpdate:modelValue": _cache[12] || (_cache[12] = ($event) => __props.deliveryConfig.autoReply = $event),
                  "true-value": 1,
                  "false-value": 0,
                  onChange: _cache[13] || (_cache[13] = ($event) => saveConfig(false))
                }, null, 544), [
                  [vModelCheckbox, __props.deliveryConfig.autoReply]
                ]),
                _cache[31] || (_cache[31] = createBaseVNode("span", { class: "slider round" }, null, -1))
              ])
            ])
          ]),
          createBaseVNode("div", _hoisted_18$2, [
            _cache[36] || (_cache[36] = createBaseVNode("div", { class: "config-label" }, [
              createBaseVNode("span", null, "我的位置"),
              createBaseVNode("small", null, "设置您的常驻位置，用于距离筛选（高级功能）")
            ], -1)),
            createBaseVNode("div", _hoisted_19$2, [
              createBaseVNode("button", {
                class: "location-btn",
                onClick: getCurrentLocation
              }, [
                createVNode(_component_el_icon, null, {
                  default: withCtx(() => [
                    createVNode(unref(location_default))
                  ]),
                  _: 1
                }),
                _cache[33] || (_cache[33] = createTextVNode(" 获取当前位置 ", -1))
              ]),
              createBaseVNode("div", _hoisted_20$2, [
                withDirectives(createBaseVNode("input", {
                  type: "number",
                  "onUpdate:modelValue": _cache[14] || (_cache[14] = ($event) => __props.deliveryConfig.userLongitude = $event),
                  placeholder: "经度，如: 116.4074",
                  onChange: _cache[15] || (_cache[15] = ($event) => saveConfig(false)),
                  class: "coord-input",
                  step: "0.0000001"
                }, null, 544), [
                  [vModelText, __props.deliveryConfig.userLongitude]
                ]),
                _cache[34] || (_cache[34] = createBaseVNode("span", { class: "coord-separator" }, ",", -1)),
                withDirectives(createBaseVNode("input", {
                  type: "number",
                  "onUpdate:modelValue": _cache[16] || (_cache[16] = ($event) => __props.deliveryConfig.userLatitude = $event),
                  placeholder: "维度，如: 39.9042",
                  onChange: _cache[17] || (_cache[17] = ($event) => saveConfig(false)),
                  class: "coord-input",
                  step: "0.0000001"
                }, null, 544), [
                  [vModelText, __props.deliveryConfig.userLatitude]
                ])
              ]),
              _cache[35] || (_cache[35] = createBaseVNode("a", {
                href: "https://jingweidu.bmcx.com/",
                target: "_blank",
                class: "coord-lookup-link"
              }, " 手动查询 ", -1))
            ])
          ]),
          __props.deliveryConfig.userLongitude && __props.deliveryConfig.userLatitude ? (openBlock(), createElementBlock("div", _hoisted_21$2, [
            _cache[38] || (_cache[38] = createBaseVNode("div", { class: "config-label" }, [
              createBaseVNode("span", null, "启用距离过滤"),
              createBaseVNode("small", null, "仅投递指定距离范围内的职位（基于两点坐标间的直线距离）")
            ], -1)),
            createBaseVNode("div", _hoisted_22$2, [
              createBaseVNode("label", _hoisted_23$2, [
                withDirectives(createBaseVNode("input", {
                  type: "checkbox",
                  "onUpdate:modelValue": _cache[18] || (_cache[18] = ($event) => __props.deliveryConfig.enableDistanceFilter = $event),
                  "true-value": 1,
                  "false-value": 0,
                  onChange: _cache[19] || (_cache[19] = ($event) => saveConfig(false))
                }, null, 544), [
                  [vModelCheckbox, __props.deliveryConfig.enableDistanceFilter]
                ]),
                _cache[37] || (_cache[37] = createBaseVNode("span", { class: "slider round" }, null, -1))
              ])
            ])
          ])) : createCommentVNode("", true),
          __props.deliveryConfig.userLongitude && __props.deliveryConfig.userLatitude ? (openBlock(), createElementBlock("div", _hoisted_24$1, [
            _cache[39] || (_cache[39] = createBaseVNode("div", { class: "config-label" }, [
              createBaseVNode("span", null, "最大距离 (公里)"),
              createBaseVNode("small", null, "超过此距离的职位将被过滤")
            ], -1)),
            createBaseVNode("div", _hoisted_25$1, [
              withDirectives(createBaseVNode("input", {
                type: "number",
                "onUpdate:modelValue": _cache[20] || (_cache[20] = ($event) => __props.deliveryConfig.maxDistance = $event),
                placeholder: "如: 5",
                onChange: _cache[21] || (_cache[21] = ($event) => saveConfig(false)),
                disabled: __props.deliveryConfig.enableDistanceFilter != 1,
                step: "0.1"
              }, null, 40, _hoisted_26$1), [
                [vModelText, __props.deliveryConfig.maxDistance]
              ])
            ])
          ])) : createCommentVNode("", true)
        ])
      ]);
    };
  }
};
const ConfigTab = /* @__PURE__ */ _export_sfc(_sfc_main$2, [["__scopeId", "data-v-9097b012"]]);
const _hoisted_1$1 = { class: "tab-pane vip-setup" };
const _hoisted_2$1 = { class: "vip-layout" };
const _hoisted_3$1 = { class: "vip-main" };
const _hoisted_4$1 = { class: "banner-content" };
const _hoisted_5$1 = { class: "medal-wrap" };
const _hoisted_6$1 = { class: "title-area" };
const _hoisted_7$1 = { key: 0 };
const _hoisted_8$1 = { key: 1 };
const _hoisted_9$1 = { class: "action-grid" };
const _hoisted_10$1 = { class: "setup-box" };
const _hoisted_11$1 = { class: "box-title" };
const _hoisted_12$1 = { class: "title-left" };
const _hoisted_13$1 = { class: "box-body" };
const _hoisted_14$1 = { class: "input-wrap" };
const _hoisted_15$1 = ["disabled"];
const _hoisted_16$1 = {
  key: 0,
  class: "setup-box"
};
const _hoisted_17$1 = { class: "box-title" };
const _hoisted_18$1 = { class: "box-body" };
const _hoisted_19$1 = { class: "input-wrap" };
const _hoisted_20$1 = ["disabled"];
const _hoisted_21$1 = { class: "vip-sidebar" };
const _hoisted_22$1 = { class: "invite-info-card" };
const _hoisted_23$1 = { class: "code-val" };
const _sfc_main$1 = {
  __name: "VipTab",
  props: {
    token: {
      type: String,
      default: ""
    },
    userInfo: {
      type: Object,
      default: null
    },
    systemConfig: {
      type: Object,
      default: () => ({})
    }
  },
  setup(__props) {
    const props = __props;
    const openBuyLink = () => {
      var _a;
      const link = ((_a = props.systemConfig) == null ? void 0 : _a.buy_link) || "https://example.com/buy";
      window.open(link, "_blank");
    };
    const activationKey = ref("");
    const referralCode = ref("");
    const isActivating = ref(false);
    const isBinding = ref(false);
    const handleActivate = () => {
      if (!activationKey.value) {
        ElMessage.warning("请输入激活密钥");
        return;
      }
      isActivating.value = true;
      http.post("/activation/use", { secretKey: activationKey.value }).then((res) => {
        if (res.code === 200) {
          ElMessage.success("激活成功！高级版权限已发放");
          activationKey.value = "";
          window.dispatchEvent(new CustomEvent("user-info-updated"));
        } else {
          ElMessage.error(res.msg || "激活失败，请检查密钥是否有效");
        }
      }).finally(() => {
        isActivating.value = false;
      });
    };
    const handleBindReferral = () => {
      if (!referralCode.value) {
        ElMessage.warning("请输入好友的邀请码");
        return;
      }
      isBinding.value = true;
      http.post("/user/bindReferral", { inviteCode: referralCode.value }).then((res) => {
        if (res.code === 200) {
          ElMessage.success("绑定成功！免费时长已到账");
          referralCode.value = "";
          window.dispatchEvent(new CustomEvent("user-info-updated"));
        } else {
          ElMessage.error(res.msg || "绑定失败，请检查邀请码是否正确");
        }
      }).finally(() => {
        isBinding.value = false;
      });
    };
    const copyMyCode = () => {
      var _a;
      if (!((_a = props.userInfo) == null ? void 0 : _a.inviteCode)) return;
      navigator.clipboard.writeText(props.userInfo.inviteCode).then(() => {
        ElMessage.success("您的邀请码已复制");
      });
    };
    const formatTime = (time) => {
      if (!time) return "永久有效";
      const date = new Date(time);
      const y = date.getFullYear();
      const m = String(date.getMonth() + 1).padStart(2, "0");
      const d = String(date.getDate()).padStart(2, "0");
      const hh = String(date.getHours()).padStart(2, "0");
      const mm = String(date.getMinutes()).padStart(2, "0");
      const ss = String(date.getSeconds()).padStart(2, "0");
      return `${y}-${m}-${d} ${hh}:${mm}:${ss}`;
    };
    return (_ctx, _cache) => {
      var _a, _b, _c, _d, _e, _f;
      return openBlock(), createElementBlock("div", _hoisted_1$1, [
        _cache[11] || (_cache[11] = createBaseVNode("div", { class: "section-header" }, [
          createBaseVNode("h2", null, "会员状态与权益激活")
        ], -1)),
        createBaseVNode("div", _hoisted_2$1, [
          createBaseVNode("div", _hoisted_3$1, [
            createBaseVNode("div", {
              class: normalizeClass(["status-banner", { "gold": (_a = __props.userInfo) == null ? void 0 : _a.isPremium }])
            }, [
              createBaseVNode("div", _hoisted_4$1, [
                createBaseVNode("div", _hoisted_5$1, [
                  ((_b = __props.userInfo) == null ? void 0 : _b.isPremium) ? (openBlock(), createBlock(unref(ticket_default), {
                    key: 0,
                    class: "medal-icon"
                  })) : (openBlock(), createBlock(unref(user_default), {
                    key: 1,
                    class: "medal-icon"
                  }))
                ]),
                createBaseVNode("div", _hoisted_6$1, [
                  createBaseVNode("h3", null, toDisplayString(((_c = __props.userInfo) == null ? void 0 : _c.isPremium) ? "全功能专业版用户" : "当前为免费版用户"), 1),
                  ((_d = __props.userInfo) == null ? void 0 : _d.isPremium) ? (openBlock(), createElementBlock("p", _hoisted_7$1, "到期时间：" + toDisplayString(formatTime(__props.userInfo.premiumEndTime)), 1)) : (openBlock(), createElementBlock("p", _hoisted_8$1, "通过邀请好友或输入密钥，立即解锁所有高级功能"))
                ])
              ])
            ], 2),
            createBaseVNode("div", _hoisted_9$1, [
              createBaseVNode("div", _hoisted_10$1, [
                _cache[4] || (_cache[4] = createBaseVNode("div", { class: "box-tag" }, "正式版", -1)),
                createBaseVNode("div", _hoisted_11$1, [
                  createBaseVNode("div", _hoisted_12$1, [
                    createVNode(unref(key_default), { class: "el-icon" }),
                    _cache[2] || (_cache[2] = createTextVNode(" 输入激活密钥 ", -1))
                  ]),
                  createBaseVNode("a", {
                    class: "buy-link-title",
                    onClick: openBuyLink
                  }, " 还没有密钥？去购买 → ")
                ]),
                createBaseVNode("div", _hoisted_13$1, [
                  createBaseVNode("div", _hoisted_14$1, [
                    withDirectives(createBaseVNode("input", {
                      "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => activationKey.value = $event),
                      placeholder: "BOSS-XXXX-XXXX"
                    }, null, 512), [
                      [vModelText, activationKey.value]
                    ]),
                    createBaseVNode("button", {
                      class: "prime-btn",
                      onClick: handleActivate,
                      disabled: isActivating.value
                    }, [
                      createBaseVNode("span", null, toDisplayString(isActivating.value ? "处理中" : "立即激活"), 1)
                    ], 8, _hoisted_15$1)
                  ]),
                  _cache[3] || (_cache[3] = createBaseVNode("div", { class: "box-footer-actions" }, [
                    createBaseVNode("small", null, "用于核销购买的时长卡，一次性使用")
                  ], -1))
                ])
              ]),
              !((_e = __props.userInfo) == null ? void 0 : _e.referrerId) ? (openBlock(), createElementBlock("div", _hoisted_16$1, [
                _cache[7] || (_cache[7] = createBaseVNode("div", { class: "box-tag gift" }, "受邀礼", -1)),
                createBaseVNode("div", _hoisted_17$1, [
                  createVNode(unref(share_default), { class: "el-icon" }),
                  _cache[5] || (_cache[5] = createTextVNode(" 填写好友邀请码 ", -1))
                ]),
                createBaseVNode("div", _hoisted_18$1, [
                  createBaseVNode("div", _hoisted_19$1, [
                    withDirectives(createBaseVNode("input", {
                      "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => referralCode.value = $event),
                      placeholder: "输入 6 位代码"
                    }, null, 512), [
                      [vModelText, referralCode.value]
                    ]),
                    createBaseVNode("button", {
                      class: "ghost-btn",
                      onClick: handleBindReferral,
                      disabled: isBinding.value
                    }, [
                      createBaseVNode("span", null, toDisplayString(isBinding.value ? "提交中" : "确认关联"), 1)
                    ], 8, _hoisted_20$1)
                  ]),
                  _cache[6] || (_cache[6] = createBaseVNode("small", null, "成功绑定后，您将额外获得 3 天免费试用", -1))
                ])
              ])) : createCommentVNode("", true)
            ])
          ]),
          createBaseVNode("div", _hoisted_21$1, [
            createBaseVNode("div", _hoisted_22$1, [
              _cache[8] || (_cache[8] = createBaseVNode("h4", null, "我的专属邀请码", -1)),
              createBaseVNode("div", {
                class: "code-box",
                onClick: copyMyCode
              }, [
                createBaseVNode("span", _hoisted_23$1, toDisplayString(((_f = __props.userInfo) == null ? void 0 : _f.inviteCode) || "LOGGING..."), 1),
                createVNode(unref(copy_document_default), { class: "copy-ico" })
              ]),
              _cache[9] || (_cache[9] = createBaseVNode("div", { class: "invite-stats" }, [
                createBaseVNode("p", null, "每邀请一位有效新用户"),
                createBaseVNode("strong", null, "自动奖励 3 天高级版")
              ], -1)),
              _cache[10] || (_cache[10] = createBaseVNode("p", { class: "desc" }, "分享这个代码给面试群或朋友，他们填写后双方均可得奖励。", -1))
            ])
          ])
        ])
      ]);
    };
  }
};
const VipTab = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["__scopeId", "data-v-c44e021d"]]);
const _hoisted_1 = { class: "dashboard" };
const _hoisted_2 = { class: "dashboard-header" };
const _hoisted_3 = { class: "header-right" };
const _hoisted_4 = {
  key: 0,
  class: "user-profile"
};
const _hoisted_5 = ["title"];
const _hoisted_6 = ["src"];
const _hoisted_7 = {
  key: 0,
  class: "update-dot-container"
};
const _hoisted_8 = { class: "user-info" };
const _hoisted_9 = { class: "user-nickname" };
const _hoisted_10 = { class: "user-tag-row" };
const _hoisted_11 = {
  key: 0,
  class: "announcement-bar"
};
const _hoisted_12 = { class: "announcement-inner" };
const _hoisted_13 = { class: "announcement-scroll" };
const _hoisted_14 = { class: "announcement-text" };
const _hoisted_15 = { class: "stats-section" };
const _hoisted_16 = { class: "stats-grid" };
const _hoisted_17 = { class: "stat-card stat-total" };
const _hoisted_18 = { class: "stat-icon" };
const _hoisted_19 = { class: "stat-content" };
const _hoisted_20 = { class: "stat-value" };
const _hoisted_21 = { class: "stat-card stat-today" };
const _hoisted_22 = { class: "stat-icon" };
const _hoisted_23 = { class: "stat-content" };
const _hoisted_24 = { class: "stat-value" };
const _hoisted_25 = { class: "stat-card stat-week" };
const _hoisted_26 = { class: "stat-icon" };
const _hoisted_27 = { class: "stat-content" };
const _hoisted_28 = { class: "stat-value" };
const _hoisted_29 = { class: "tabs-section" };
const _hoisted_30 = { class: "tabs-nav" };
const _hoisted_31 = {
  key: 0,
  class: "badge"
};
const _hoisted_32 = {
  key: 0,
  class: "badge badge-green"
};
const _hoisted_33 = {
  key: 0,
  class: "badge"
};
const _hoisted_34 = { class: "tab-content" };
const _hoisted_35 = { class: "modal-header" };
const _hoisted_36 = { class: "modal-body" };
const _hoisted_37 = { class: "qr-container" };
const _hoisted_38 = ["src"];
const _hoisted_39 = {
  key: 0,
  class: "qr-loading-overlay"
};
const _hoisted_40 = { class: "update-body" };
const _hoisted_41 = { class: "update-version" };
const _hoisted_42 = { class: "update-actions" };
const currentVersion = "1.0";
const _sfc_main = {
  __name: "Dashboard",
  setup(__props) {
    const activeTab = ref("config");
    const announcement = ref("");
    const systemConfig = ref({});
    const showAnnouncement = ref(true);
    const isUpdateAvailable = ref(false);
    const showUpdateModal = ref(false);
    const stats = ref({
      totalDelivered: 0,
      todayDelivered: 0,
      weekDelivered: 0
    });
    const deliveryHistory = ref([]);
    const filterCompany = ref([]);
    const blacklistKeywords = ref([]);
    const whitelistKeywords = ref([]);
    const templates = ref([]);
    const activeTemplateId = ref(null);
    const deliveryConfig = ref({
      deliveryCount: 100,
      salaryMin: 0,
      salaryMax: 0,
      onlyOnlineHr: 0,
      skipCommunicated: 0
    });
    const configTabRef = ref(null);
    const showLoginQR = ref(false);
    const isQRLoading = ref(true);
    const sessionId = ref("");
    const qrCodeUrl = ref("");
    const socket = ref(null);
    const token = ref("");
    const userInfo = ref(null);
    const calculateStats = () => {
      if (!token.value) return;
      http.get("/deliveryHistory/stats").then((res) => {
        if (res.code === 200 && res.data) {
          stats.value = res.data;
          chrome.storage.local.set({ deliveryStats: stats.value });
        }
      }).catch((err) => console.error("获取统计数据失败:", err));
    };
    const refreshConfig = () => {
      nextTick(() => {
        if (configTabRef.value) {
          configTabRef.value.loadConfig();
        }
      });
    };
    const fetchSystemConfig = () => {
      fetch(`${baseUrl}/api/public/config`).then((res) => res.json()).then((data) => {
        if (data.code === 200 && data.data) {
          systemConfig.value = data.data;
          if (data.data.announcement) {
            const newNotice = data.data.announcement;
            announcement.value = newNotice;
            chrome.storage.local.get(["closedAnnouncement"], (result) => {
              if (result.closedAnnouncement === newNotice) {
                showAnnouncement.value = false;
              } else {
                showAnnouncement.value = true;
              }
            });
          }
          checkVersion(data.data);
        }
      }).catch((err) => console.warn("[Dashboard] 获取系统配置失败:", err));
    };
    const handleCloseNotice = () => {
      showAnnouncement.value = false;
      chrome.storage.local.set({ closedAnnouncement: announcement.value });
    };
    const checkVersion = (config) => {
      if (!config.latest_version) return;
      const latest = config.latest_version;
      if (latest !== currentVersion && compareVersion(latest, currentVersion) > 0) {
        isUpdateAvailable.value = true;
        console.log(`[Dashboard] 检测到新版本: ${latest}`);
      }
    };
    const compareVersion = (v1, v2) => {
      const a = v1.split(".").map(Number);
      const b = v2.split(".").map(Number);
      const len = Math.max(a.length, b.length);
      for (let i = 0; i < len; i++) {
        const x = a[i] || 0;
        const y = b[i] || 0;
        if (x > y) return 1;
        if (x < y) return -1;
      }
      return 0;
    };
    const handleAvatarClick = () => {
      if (isUpdateAvailable.value) {
        showUpdateModal.value = true;
      } else {
        handleLogout();
      }
    };
    const goToWebsite = () => {
      const url = systemConfig.value.official_website || "https://example.com";
      window.open(url, "_blank");
    };
    const goToTutorial = () => {
      const url = systemConfig.value.install_tutorial || "https://example.com/tutorial";
      window.open(url, "_blank");
    };
    onMounted(() => {
      const urlParams = new URLSearchParams(window.location.search);
      const tabParam = urlParams.get("tab");
      if (tabParam) {
        activeTab.value = tabParam;
        console.log("[Dashboard] 根据 URL 参数跳转 Tab:", tabParam);
      }
      loadData();
      fetchSystemConfig();
      chrome.storage.local.get(["token", "userInfo"], (result) => {
        if (result.token) {
          token.value = result.token;
          userInfo.value = result.userInfo;
          showLoginQR.value = false;
          refreshUserInfo();
          loadRemoteData();
          calculateStats();
        } else {
          showLoginQR.value = true;
          initLogin();
        }
      });
      chrome.storage.onChanged.addListener((changes) => {
        if (changes.deliveryHistory) {
          deliveryHistory.value = changes.deliveryHistory.newValue || [];
          calculateStats();
        }
        if (changes.filterCompany) {
          filterCompany.value = ensureArray(changes.filterCompany.newValue);
        }
        if (changes.blacklistKeywords) {
          blacklistKeywords.value = ensureArray(changes.blacklistKeywords.newValue);
        }
        if (changes.whitelistKeywords) {
          whitelistKeywords.value = ensureArray(changes.whitelistKeywords.newValue);
        }
        if (changes.templates) {
          templates.value = ensureArray(changes.templates.newValue);
        }
        if (changes.activeTemplateId) {
          activeTemplateId.value = changes.activeTemplateId.newValue;
        }
        if (changes.token) {
          token.value = changes.token.newValue;
          if (token.value) {
            showLoginQR.value = false;
            refreshConfig();
            loadRemoteData();
            calculateStats();
            if (socket.value) {
              socket.value.close();
            }
          }
        }
      });
      window.addEventListener("auth-expired", handleAuthExpired);
      window.addEventListener("user-info-updated", refreshUserInfo);
    });
    const refreshUserInfo = () => {
      if (!token.value) return;
      http.get("/user/info").then((res) => {
        var _a;
        if (res.code === 200 && res.data) {
          const oldPremium = (_a = userInfo.value) == null ? void 0 : _a.isPremium;
          userInfo.value = res.data;
          chrome.storage.local.set({ userInfo: res.data });
          if (oldPremium !== res.data.isPremium) {
            console.log("[Dashboard] 会员状态变化，重新加载配置...");
            loadRemoteData();
          }
        }
      });
    };
    const handleAuthExpired = () => {
      ElMessage.warning("登录已过期，请重新登录");
      token.value = "";
      userInfo.value = null;
      showLoginQR.value = true;
      initLogin();
    };
    onUnmounted(() => {
      window.removeEventListener("auth-expired", handleAuthExpired);
      window.removeEventListener("user-info-updated", refreshUserInfo);
    });
    const loadRemoteData = () => {
      if (!token.value) return;
      http.get("/filterRule/list?type=1").then((res) => {
        if (res.data && res.data.length > 0) {
          blacklistKeywords.value = res.data.map((i) => i.ruleValue);
          chrome.storage.local.set({ blacklistKeywords: blacklistKeywords.value });
        }
      });
      http.get("/filterRule/list?type=2").then((res) => {
        if (res.data && res.data.length > 0) {
          whitelistKeywords.value = res.data.map((i) => i.ruleValue);
          chrome.storage.local.set({ whitelistKeywords: whitelistKeywords.value });
        }
      });
      http.get("/filterRule/list?type=3").then((res) => {
        if (res.data && res.data.length > 0) {
          filterCompany.value = res.data.map((i) => i.ruleValue);
          chrome.storage.local.set({ filterCompany: filterCompany.value });
        }
      });
      http.get("/deliveryTemplate/list").then((res) => {
        if (res.data && res.data.length > 0) {
          templates.value = res.data.map((t) => ({
            id: t.templateId,
            name: t.templateName,
            content: t.content,
            isDefault: t.isDefault,
            isAiEnabled: t.isAiEnabled || 0
          }));
          chrome.storage.local.set({ templates: templates.value });
          const defaultTemplate = templates.value.find((t) => t.isDefault === 1);
          if (defaultTemplate) {
            activeTemplateId.value = defaultTemplate.id;
            chrome.storage.local.set({
              activeTemplateId: defaultTemplate.id,
              text: defaultTemplate.content,
              isAiEnabled: defaultTemplate.isAiEnabled
            });
          }
        }
      });
      refreshConfig();
    };
    const ensureArray = (data) => {
      if (!data) return [];
      if (Array.isArray(data)) return data;
      if (typeof data === "object") {
        return Object.values(data);
      }
      return [];
    };
    const loadData = () => {
      chrome.storage.local.get([
        "deliveryHistory",
        "deliveryStats"
      ], (result) => {
        if (result.deliveryHistory) {
          deliveryHistory.value = result.deliveryHistory.sort(
            (a, b) => new Date(b.time) - new Date(a.time)
          );
        }
        if (result.deliveryStats) {
          stats.value = result.deliveryStats;
        }
        calculateStats();
        refreshConfig();
      });
    };
    const initLogin = () => {
      sessionId.value = Math.random().toString(36).substring(2, 15) + Date.now().toString(36);
      qrCodeUrl.value = `${baseUrl}/login/getQRCode?sessionId=${sessionId.value}`;
      isQRLoading.value = true;
      if (socket.value) {
        socket.value.close();
      }
      socket.value = new WebSocket(`${wsUrl}/ws/login/${sessionId.value}`);
      socket.value.onopen = () => {
        console.log("WebSocket 连接成功, sessionId:", sessionId.value);
      };
      socket.value.onmessage = (event) => {
        try {
          const data = JSON.parse(event.data);
          if (data.type === "connected") {
            console.log("WebSocket 已就绪, sessionId:", data.sessionId);
          } else if (data.type === "login_success") {
            console.log("微信登录成功:", data);
            ElMessage.success("微信登录成功");
            token.value = data.token;
            userInfo.value = data.userInfo;
            chrome.storage.local.set({
              token: data.token,
              userInfo: data.userInfo
            }, () => {
              showLoginQR.value = false;
              if (socket.value) {
                socket.value.close();
                socket.value = null;
              }
            });
          } else if (data.type === "login_failed") {
            console.error("登录失败:", data.message);
            ElMessage.error(data.message || "登录失败");
            showLoginQR.value = false;
          }
        } catch (e) {
          console.error("解析 WebSocket 消息失败:", e);
        }
      };
      socket.value.onclose = () => {
        console.log("WebSocket 连接已关闭");
      };
      socket.value.onerror = (error) => {
        console.error("WebSocket 发生错误:", error);
        isQRLoading.value = false;
      };
    };
    const onQRCodeLoad = () => {
      isQRLoading.value = false;
    };
    const handleLogout = () => {
      if (confirm("确定要退出登录吗？")) {
        chrome.storage.local.remove(["token", "userInfo"], () => {
          token.value = "";
          userInfo.value = null;
          showLoginQR.value = true;
          initLogin();
          ElMessage.success("已退出登录");
        });
      }
    };
    const handleRefresh = () => {
      initLogin();
    };
    return (_ctx, _cache) => {
      var _a, _b;
      return openBlock(), createElementBlock("div", _hoisted_1, [
        createBaseVNode("header", _hoisted_2, [
          createBaseVNode("div", { class: "header-left" }, [
            createBaseVNode("div", { class: "logo-wrap" }, [
              createBaseVNode("div", {
                class: "logo",
                onClick: goToWebsite,
                title: "访问官网"
              }, "B"),
              createBaseVNode("div", { class: "logo-text" }, [
                _cache[24] || (_cache[24] = createBaseVNode("h1", null, "Boss 自动投递", -1)),
                createBaseVNode("div", { class: "subtitle-row" }, [
                  _cache[23] || (_cache[23] = createBaseVNode("span", { class: "subtitle" }, "投递管理后台", -1)),
                  createBaseVNode("span", {
                    class: "tutorial-tag",
                    onClick: goToTutorial
                  }, "安装教程")
                ])
              ])
            ])
          ]),
          createBaseVNode("div", _hoisted_3, [
            userInfo.value ? (openBlock(), createElementBlock("div", _hoisted_4, [
              createBaseVNode("div", {
                class: "avatar-wrap",
                onClick: handleAvatarClick,
                title: isUpdateAvailable.value ? "发现新版本，确认更新" : "点击退出登录"
              }, [
                createBaseVNode("img", {
                  src: userInfo.value.avatar || "https://cube.elemecdn.com/3/7c/3ea6beec64369c2642b92c6726f1epng.png",
                  class: "user-avatar",
                  onError: _cache[0] || (_cache[0] = (e) => e.target.src = "https://cube.elemecdn.com/3/7c/3ea6beec64369c2642b92c6726f1epng.png")
                }, null, 40, _hoisted_6),
                isUpdateAvailable.value ? (openBlock(), createElementBlock("div", _hoisted_7, [..._cache[25] || (_cache[25] = [
                  createBaseVNode("span", { class: "update-dot-inner" }, null, -1)
                ])])) : createCommentVNode("", true)
              ], 8, _hoisted_5),
              createBaseVNode("div", _hoisted_8, [
                createBaseVNode("span", _hoisted_9, toDisplayString(userInfo.value.nickname || "微信用户"), 1),
                createBaseVNode("div", _hoisted_10, [
                  createBaseVNode("span", {
                    class: normalizeClass(["user-tag", { "premium": userInfo.value.isPremium }])
                  }, toDisplayString(userInfo.value.isPremium ? "全功能版" : "免费版"), 3),
                  isUpdateAvailable.value ? (openBlock(), createElementBlock("span", {
                    key: 0,
                    class: "version-hint-tag",
                    onClick: _cache[1] || (_cache[1] = ($event) => showUpdateModal.value = true)
                  }, " 有新版本待更新 ")) : createCommentVNode("", true)
                ])
              ])
            ])) : createCommentVNode("", true)
          ])
        ]),
        announcement.value && showAnnouncement.value ? (openBlock(), createElementBlock("div", _hoisted_11, [
          createBaseVNode("div", _hoisted_12, [
            _cache[26] || (_cache[26] = createBaseVNode("span", { class: "announcement-icon" }, "📢", -1)),
            createBaseVNode("div", _hoisted_13, [
              createBaseVNode("span", _hoisted_14, toDisplayString(announcement.value), 1)
            ]),
            createBaseVNode("button", {
              class: "announcement-close",
              onClick: handleCloseNotice
            }, "×")
          ])
        ])) : createCommentVNode("", true),
        createBaseVNode("section", _hoisted_15, [
          createBaseVNode("div", _hoisted_16, [
            createBaseVNode("div", _hoisted_17, [
              createBaseVNode("div", _hoisted_18, [
                createVNode(unref(document_default), { class: "el-icon-lg" })
              ]),
              createBaseVNode("div", _hoisted_19, [
                createBaseVNode("div", _hoisted_20, toDisplayString(stats.value.totalDelivered), 1),
                _cache[27] || (_cache[27] = createBaseVNode("div", { class: "stat-label" }, "总投递数", -1))
              ])
            ]),
            createBaseVNode("div", _hoisted_21, [
              createBaseVNode("div", _hoisted_22, [
                createVNode(unref(calendar_default), { class: "el-icon-lg" })
              ]),
              createBaseVNode("div", _hoisted_23, [
                createBaseVNode("div", _hoisted_24, toDisplayString(stats.value.todayDelivered), 1),
                _cache[28] || (_cache[28] = createBaseVNode("div", { class: "stat-label" }, "今日投递", -1))
              ])
            ]),
            createBaseVNode("div", _hoisted_25, [
              createBaseVNode("div", _hoisted_26, [
                createVNode(unref(trend_charts_default), { class: "el-icon-lg" })
              ]),
              createBaseVNode("div", _hoisted_27, [
                createBaseVNode("div", _hoisted_28, toDisplayString(stats.value.weekDelivered), 1),
                _cache[29] || (_cache[29] = createBaseVNode("div", { class: "stat-label" }, "本周投递", -1))
              ])
            ])
          ])
        ]),
        createBaseVNode("section", _hoisted_29, [
          createBaseVNode("div", _hoisted_30, [
            createBaseVNode("button", {
              class: normalizeClass(["tab-btn", { active: activeTab.value === "config" }]),
              onClick: _cache[2] || (_cache[2] = ($event) => {
                activeTab.value = "config";
                refreshConfig();
              })
            }, [
              createVNode(unref(setting_default), { class: "el-icon" }),
              _cache[30] || (_cache[30] = createTextVNode(" 基础配置 ", -1))
            ], 2),
            createBaseVNode("button", {
              class: normalizeClass(["tab-btn", { active: activeTab.value === "vip" }]),
              onClick: _cache[3] || (_cache[3] = ($event) => {
                activeTab.value = "vip";
                refreshUserInfo();
              })
            }, [
              createVNode(unref(ticket_default), { class: "el-icon" }),
              _cache[31] || (_cache[31] = createTextVNode(" 会员特权 ", -1))
            ], 2),
            createBaseVNode("button", {
              class: normalizeClass(["tab-btn", { active: activeTab.value === "template" }]),
              onClick: _cache[4] || (_cache[4] = ($event) => activeTab.value = "template")
            }, [
              createVNode(unref(edit_default), { class: "el-icon" }),
              _cache[32] || (_cache[32] = createTextVNode(" 打招呼模板 ", -1))
            ], 2),
            createBaseVNode("button", {
              class: normalizeClass(["tab-btn", { active: activeTab.value === "blacklist" }]),
              onClick: _cache[5] || (_cache[5] = ($event) => activeTab.value = "blacklist")
            }, [
              createVNode(unref(circle_close_default), { class: "el-icon" }),
              _cache[33] || (_cache[33] = createTextVNode(" 职位关键词黑名单 ", -1)),
              blacklistKeywords.value.length ? (openBlock(), createElementBlock("span", _hoisted_31, toDisplayString(blacklistKeywords.value.length), 1)) : createCommentVNode("", true)
            ], 2),
            createBaseVNode("button", {
              class: normalizeClass(["tab-btn", { active: activeTab.value === "whitelist" }]),
              onClick: _cache[6] || (_cache[6] = ($event) => activeTab.value = "whitelist")
            }, [
              createVNode(unref(check_default), { class: "el-icon" }),
              _cache[34] || (_cache[34] = createTextVNode(" 职位关键词白名单 ", -1)),
              whitelistKeywords.value.length ? (openBlock(), createElementBlock("span", _hoisted_32, toDisplayString(whitelistKeywords.value.length), 1)) : createCommentVNode("", true)
            ], 2),
            createBaseVNode("button", {
              class: normalizeClass(["tab-btn", { active: activeTab.value === "company" }]),
              onClick: _cache[7] || (_cache[7] = ($event) => activeTab.value = "company")
            }, [
              createVNode(unref(office_building_default), { class: "el-icon" }),
              _cache[35] || (_cache[35] = createTextVNode(" 过滤公司 ", -1)),
              filterCompany.value.length ? (openBlock(), createElementBlock("span", _hoisted_33, toDisplayString(filterCompany.value.length), 1)) : createCommentVNode("", true)
            ], 2),
            createBaseVNode("button", {
              class: normalizeClass(["tab-btn", {
                active: activeTab.value === "history",
                locked: !((_a = userInfo.value) == null ? void 0 : _a.isPremium)
              }]),
              onClick: _cache[8] || (_cache[8] = ($event) => activeTab.value = "history")
            }, [
              ((_b = userInfo.value) == null ? void 0 : _b.isPremium) ? (openBlock(), createBlock(unref(document_default), {
                key: 0,
                class: "el-icon"
              })) : (openBlock(), createBlock(unref(lock_default), {
                key: 1,
                class: "el-icon"
              })),
              _cache[36] || (_cache[36] = createTextVNode(" 投递历史 ", -1))
            ], 2)
          ]),
          createBaseVNode("div", _hoisted_34, [
            activeTab.value === "config" ? (openBlock(), createBlock(ConfigTab, {
              key: 0,
              ref_key: "configTabRef",
              ref: configTabRef,
              deliveryConfig: deliveryConfig.value,
              "onUpdate:deliveryConfig": _cache[9] || (_cache[9] = ($event) => deliveryConfig.value = $event),
              token: token.value
            }, null, 8, ["deliveryConfig", "token"])) : createCommentVNode("", true),
            activeTab.value === "vip" ? (openBlock(), createBlock(VipTab, {
              key: 1,
              token: token.value,
              userInfo: userInfo.value,
              systemConfig: systemConfig.value
            }, null, 8, ["token", "userInfo", "systemConfig"])) : createCommentVNode("", true),
            activeTab.value === "history" ? (openBlock(), createBlock(HistoryTab, {
              key: 2,
              ref: "historyTabRef",
              stats: stats.value,
              userInfo: userInfo.value,
              onCalculateStats: calculateStats,
              onSwitchTab: _cache[10] || (_cache[10] = ($event) => activeTab.value = $event)
            }, null, 8, ["stats", "userInfo"])) : createCommentVNode("", true),
            activeTab.value === "company" ? (openBlock(), createBlock(CompanyTab, {
              key: 3,
              filterCompany: filterCompany.value,
              "onUpdate:filterCompany": _cache[11] || (_cache[11] = ($event) => filterCompany.value = $event),
              token: token.value
            }, null, 8, ["filterCompany", "token"])) : createCommentVNode("", true),
            activeTab.value === "blacklist" ? (openBlock(), createBlock(BlacklistTab, {
              key: 4,
              blacklistKeywords: blacklistKeywords.value,
              "onUpdate:blacklistKeywords": _cache[12] || (_cache[12] = ($event) => blacklistKeywords.value = $event),
              token: token.value
            }, null, 8, ["blacklistKeywords", "token"])) : createCommentVNode("", true),
            activeTab.value === "whitelist" ? (openBlock(), createBlock(WhitelistTab, {
              key: 5,
              whitelistKeywords: whitelistKeywords.value,
              "onUpdate:whitelistKeywords": _cache[13] || (_cache[13] = ($event) => whitelistKeywords.value = $event),
              token: token.value
            }, null, 8, ["whitelistKeywords", "token"])) : createCommentVNode("", true),
            activeTab.value === "template" ? (openBlock(), createBlock(TemplateTab, {
              key: 6,
              templates: templates.value,
              "onUpdate:templates": _cache[14] || (_cache[14] = ($event) => templates.value = $event),
              activeTemplateId: activeTemplateId.value,
              "onUpdate:activeTemplateId": _cache[15] || (_cache[15] = ($event) => activeTemplateId.value = $event),
              token: token.value,
              userInfo: userInfo.value
            }, null, 8, ["templates", "activeTemplateId", "token", "userInfo"])) : createCommentVNode("", true)
          ])
        ]),
        _cache[44] || (_cache[44] = createBaseVNode("footer", { class: "dashboard-footer" }, [
          createBaseVNode("p", null, "Boss 自动投递 · 高效投递，精准匹配")
        ], -1)),
        showLoginQR.value ? (openBlock(), createElementBlock("div", {
          key: 1,
          class: "modal-overlay",
          onClick: _cache[18] || (_cache[18] = ($event) => token.value ? showLoginQR.value = false : null)
        }, [
          createBaseVNode("div", {
            class: "modal-content",
            onClick: _cache[17] || (_cache[17] = withModifiers(() => {
            }, ["stop"]))
          }, [
            createBaseVNode("div", _hoisted_35, [
              _cache[37] || (_cache[37] = createBaseVNode("h3", null, "微信扫码登录", -1)),
              token.value ? (openBlock(), createElementBlock("button", {
                key: 0,
                class: "close-btn",
                onClick: _cache[16] || (_cache[16] = ($event) => showLoginQR.value = false)
              }, "×")) : createCommentVNode("", true)
            ]),
            createBaseVNode("div", _hoisted_36, [
              createBaseVNode("div", _hoisted_37, [
                createBaseVNode("img", {
                  src: qrCodeUrl.value,
                  alt: "登录二维码",
                  class: normalizeClass(["qr-code", { loading: isQRLoading.value }]),
                  onLoad: onQRCodeLoad
                }, null, 42, _hoisted_38),
                isQRLoading.value ? (openBlock(), createElementBlock("div", _hoisted_39, [..._cache[38] || (_cache[38] = [
                  createBaseVNode("div", { class: "spinner" }, null, -1)
                ])])) : createCommentVNode("", true)
              ]),
              _cache[40] || (_cache[40] = createBaseVNode("p", null, "请使用微信扫描上方二维码确认登录", -1)),
              createBaseVNode("div", { class: "login-tips" }, [
                createBaseVNode("button", {
                  class: "refresh-link",
                  onClick: handleRefresh,
                  style: { "background": "none", "border": "none", "color": "#00bebd", "cursor": "pointer", "text-decoration": "underline", "font-size": "12px" }
                }, " 二维码过期？点击刷新 "),
                _cache[39] || (_cache[39] = createBaseVNode("p", { style: { "font-size": "11px", "margin-top": "8px" } }, "确认登录后即可进入管理后台", -1))
              ])
            ])
          ])
        ])) : createCommentVNode("", true),
        showUpdateModal.value ? (openBlock(), createElementBlock("div", {
          key: 2,
          class: "modal-overlay",
          onClick: _cache[22] || (_cache[22] = ($event) => showUpdateModal.value = false)
        }, [
          createBaseVNode("div", {
            class: "modal-content update-modal",
            onClick: _cache[21] || (_cache[21] = withModifiers(() => {
            }, ["stop"]))
          }, [
            _cache[43] || (_cache[43] = createBaseVNode("div", { class: "update-header" }, [
              createBaseVNode("span", { class: "update-icon" }, "🚀"),
              createBaseVNode("h3", null, "发现新版本")
            ], -1)),
            createBaseVNode("div", _hoisted_40, [
              createBaseVNode("p", _hoisted_41, [
                _cache[41] || (_cache[41] = createTextVNode("最新版本：", -1)),
                createBaseVNode("strong", null, "v" + toDisplayString(systemConfig.value.latest_version), 1)
              ]),
              createBaseVNode("p", { class: "update-current" }, "当前版本：v" + toDisplayString(currentVersion)),
              _cache[42] || (_cache[42] = createBaseVNode("p", { class: "update-desc" }, "建议更新到最新版本以享受最新功能和优化。", -1)),
              createBaseVNode("div", _hoisted_42, [
                createBaseVNode("button", {
                  class: "btn-primary-sm",
                  onClick: _cache[19] || (_cache[19] = () => {
                    const url = systemConfig.value.download_url || "#";
                    _ctx.window.open(url, "_blank");
                  })
                }, "立即下载"),
                createBaseVNode("button", {
                  class: "btn-text",
                  onClick: _cache[20] || (_cache[20] = ($event) => showUpdateModal.value = false)
                }, "以后再说")
              ])
            ])
          ])
        ])) : createCommentVNode("", true)
      ]);
    };
  }
};
const Dashboard = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-b4d224a4"]]);
createApp(Dashboard).mount("#app");
