function isExtensionContextValid() {
  try {
    return !!(chrome.runtime && chrome.runtime.id);
  } catch (e) {
    return false;
  }
}
async function safeStorageGet(keys) {
  if (!isExtensionContextValid()) {
    console.warn("[Boss插件] 扩展上下文已失效，请刷新页面");
    return {};
  }
  try {
    return await chrome.storage.local.get(keys);
  } catch (e) {
    console.warn("[Boss插件] storage.get 失败:", e.message);
    return {};
  }
}
async function safeStorageSet(data) {
  if (!isExtensionContextValid()) {
    console.warn("[Boss插件] 扩展上下文已失效，请刷新页面");
    return;
  }
  try {
    await chrome.storage.local.set(data);
  } catch (e) {
    console.warn("[Boss插件] storage.set 失败:", e.message);
  }
}
var deliveryConfig = {
  deliveryCount: 2,
  salaryMin: 0,
  salaryMax: 0,
  onlyOnlineHr: 0,
  skipCommunicated: 0,
  autoReply: 0,
  delayMin: 3,
  // 默认最小间隔3秒
  delayMax: 4
  // 默认最大间隔4秒
};
var loadJobCount = 0;
var positionsEligibleForApplication = [];
var blacklistKeywords = [];
var whitelistKeywords = [];
const baseUrl = "http://localhost:8002";
const http = {
  fetchWithToken: async (url, options = {}) => {
    const res = await chrome.storage.local.get("token");
    const token = res.token || "";
    const headers = {
      "Content-Type": "application/json",
      ...options.headers
    };
    if (token) headers["Authorization"] = token;
    const response = await fetch(`${baseUrl}${url}`, { ...options, headers });
    return await response.json();
  },
  get: (url) => http.fetchWithToken(url, { method: "GET" }),
  post: (url, data) => http.fetchWithToken(url, { method: "POST", body: JSON.stringify(data) }),
  delete: (url) => http.fetchWithToken(url, { method: "DELETE" })
};
async function syncConfigFromStorage() {
  const res = await chrome.storage.local.get([
    "deliveryConfig",
    "blacklistKeywords",
    "whitelistKeywords",
    "token",
    "filterCompany",
    "deliverMaxNum",
    "salaryMin",
    "salaryMax",
    "onlyOnline",
    "skipChatted",
    "delayMin",
    "delayMax",
    "autoReply",
    "trialCount",
    "maxTrialCount"
  ]);
  if (res.token) {
    console.log("[Boss插件] 检测到登录状态，从后端获取最新配置...");
    try {
      const configData = await http.get("/deliveryConfig/info");
      if (configData.code === 200 && configData.data) {
        const cloudConfig = configData.data;
        deliveryConfig.deliveryCount = cloudConfig.deliveryCount || 2;
        deliveryConfig.salaryMin = cloudConfig.salaryMin || 0;
        deliveryConfig.salaryMax = cloudConfig.salaryMax || 0;
        deliveryConfig.onlyOnlineHr = cloudConfig.onlyOnlineHr || 0;
        deliveryConfig.skipCommunicated = cloudConfig.skipCommunicated || 0;
        deliveryConfig.autoReply = cloudConfig.autoReply || 0;
        deliveryConfig.delayMin = cloudConfig.delayMin || 3;
        deliveryConfig.delayMax = cloudConfig.delayMax || 4;
        chrome.storage.local.set({
          deliveryConfig,
          deliverMaxNum: deliveryConfig.deliveryCount,
          salaryMin: deliveryConfig.salaryMin,
          salaryMax: deliveryConfig.salaryMax,
          onlyOnline: deliveryConfig.onlyOnlineHr === 1,
          skipChatted: deliveryConfig.skipCommunicated === 1,
          delayMin: deliveryConfig.delayMin,
          delayMax: deliveryConfig.delayMax
        });
        console.log("[Boss插件] ✅ 已从后端同步投递配置:", JSON.stringify(deliveryConfig));
      } else {
        console.warn("[Boss插件] 后端返回配置为空，使用本地缓存");
        applyLocalConfig(res);
      }
      const companyData = await http.get("/filterRule/list?type=3");
      if (companyData.code === 200 && Array.isArray(companyData.data)) {
        const cloudFilterList = companyData.data.map((item) => item.ruleValue);
        chrome.storage.local.set({ filterCompany: cloudFilterList });
        console.log("[Boss插件] ✅ 已同步云端公司黑名单，总计:", cloudFilterList.length);
      }
      const blacklistData = await http.get("/filterRule/list?type=1");
      if (blacklistData.code === 200 && Array.isArray(blacklistData.data)) {
        blacklistKeywords = blacklistData.data.map((item) => item.ruleValue);
        chrome.storage.local.set({ blacklistKeywords });
        console.log("[Boss插件] ✅ 已同步云端职位黑名单关键词:", blacklistKeywords);
      }
      const whitelistData = await http.get("/filterRule/list?type=2");
      if (whitelistData.code === 200 && Array.isArray(whitelistData.data)) {
        whitelistKeywords = whitelistData.data.map((item) => item.ruleValue);
        chrome.storage.local.set({ whitelistKeywords });
        console.log("[Boss插件] ✅ 已同步云端职位白名单关键词:", whitelistKeywords);
      }
    } catch (e) {
      console.warn("[Boss插件] ❌ 后台数据同步失败，降级使用本地缓存:", e);
      applyLocalConfig(res);
    }
  } else {
    console.log("[Boss插件] 未登录，使用本地存储配置");
    applyLocalConfig(res);
  }
  console.log("[Boss插件] 📋 当前生效配置:", {
    投递数量: deliveryConfig.deliveryCount,
    薪资范围: `${deliveryConfig.salaryMin}-${deliveryConfig.salaryMax}K`,
    仅在线HR: deliveryConfig.onlyOnlineHr === 1,
    跳过已沟通: deliveryConfig.skipCommunicated === 1,
    自动回复: deliveryConfig.autoReply === 1,
    间隔: `${deliveryConfig.delayMin}-${deliveryConfig.delayMax}秒`,
    黑名单关键词: blacklistKeywords,
    白名单关键词: whitelistKeywords
  });
}
function applyLocalConfig(res) {
  if (res.deliveryConfig) {
    deliveryConfig = { ...deliveryConfig, ...res.deliveryConfig };
  }
  if (res.deliverMaxNum !== void 0) deliveryConfig.deliveryCount = Number(res.deliverMaxNum);
  if (res.salaryMin !== void 0) deliveryConfig.salaryMin = Number(res.salaryMin);
  if (res.salaryMax !== void 0) deliveryConfig.salaryMax = Number(res.salaryMax);
  if (res.onlyOnline !== void 0) deliveryConfig.onlyOnlineHr = res.onlyOnline ? 1 : 0;
  if (res.skipChatted !== void 0) deliveryConfig.skipCommunicated = res.skipChatted ? 1 : 0;
  if (res.delayMin !== void 0) deliveryConfig.delayMin = Number(res.delayMin);
  if (res.delayMax !== void 0) deliveryConfig.delayMax = Number(res.delayMax);
  if (res.autoReply !== void 0) deliveryConfig.autoReply = res.autoReply ? 1 : 0;
  if (res.blacklistKeywords) {
    blacklistKeywords = Array.isArray(res.blacklistKeywords) ? res.blacklistKeywords : [];
  }
  if (res.whitelistKeywords) {
    whitelistKeywords = Array.isArray(res.whitelistKeywords) ? res.whitelistKeywords : [];
  }
  console.log("[Boss插件] ✅ 本地配置已应用:", JSON.stringify(deliveryConfig));
}
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.type === "status") {
    if (message.isRunning) {
      sendResponse({ data: "运行程序" });
      syncConfigFromStorage().then(() => {
        startProgram();
      });
    } else {
      sendResponse({ data: "程序结束运行" });
      cleanSelectView();
      hideInteractionBlocker();
    }
  }
});
const fixMappedOcrText = (text) => {
  return text.replace(/[\uE031-\uE03A]/g, (char) => {
    const code = char.charCodeAt(0);
    return code >= 57393 && code <= 57402 ? String(code - 57393) : char;
  });
};
async function filterCondition(index) {
  var cardArea = document.querySelector(".rec-job-list").querySelectorAll(".card-area")[index];
  const storeData = await chrome.storage.local.get([
    "token",
    "filterCompany",
    "blacklistKeywords",
    "whitelistKeywords"
  ]);
  let companyBlacklist, currentBlacklistKeywords, currentWhitelistKeywords;
  if (storeData.token) {
    companyBlacklist = storeData.filterCompany || [];
    currentBlacklistKeywords = blacklistKeywords || [];
    currentWhitelistKeywords = whitelistKeywords || [];
  } else {
    companyBlacklist = storeData.filterCompany || [];
    currentBlacklistKeywords = Array.isArray(storeData.blacklistKeywords) ? storeData.blacklistKeywords : [];
    currentWhitelistKeywords = Array.isArray(storeData.whitelistKeywords) ? storeData.whitelistKeywords : [];
  }
  const targetMin = deliveryConfig.salaryMin || 0;
  const targetMax = deliveryConfig.salaryMax || 0;
  const isOnlyOnlineHr = deliveryConfig.onlyOnlineHr === 1;
  const isSkipChatted = deliveryConfig.skipCommunicated === 1;
  console.log(`[Boss插件] 过滤配置: 薪资=${targetMin}-${targetMax}K, 仅在线HR=${isOnlyOnlineHr}, 跳过已沟通=${isSkipChatted}`);
  const nameEl = cardArea.querySelector(".boss-name") || cardArea.querySelector(".company-name");
  const bossCompanyName = nameEl ? (nameEl.innerText || nameEl.textContent).trim() : "";
  if (Array.isArray(companyBlacklist) && companyBlacklist.length > 0 && bossCompanyName) {
    const isBlocked = companyBlacklist.some((blockedName) => {
      if (!blockedName) return false;
      return bossCompanyName.includes(blockedName) || blockedName.includes(bossCompanyName);
    });
    if (isBlocked) {
      console.log(`[Boss插件] 公司"${bossCompanyName}"匹配黑名单项，已跳过`);
      return false;
    }
  }
  const salaryEl = cardArea.querySelector(".job-salary");
  if (salaryEl) {
    const bossSalaryStr = salaryEl.innerText;
    const bossSalaryStrTransform = fixMappedOcrText(bossSalaryStr);
    const salaryMatch = bossSalaryStrTransform.match(/(\d+)(?:\s*[Kk])?\s*-\s*(\d+)\s*[Kk]/) || bossSalaryStrTransform.match(/(\d+)-(\d+)/);
    const jobSalaryMin = salaryMatch ? parseInt(salaryMatch[1]) : 0;
    const jobSalaryMax = salaryMatch ? parseInt(salaryMatch[2]) : 0;
    if (targetMin > 0 || targetMax > 0) {
      const ifFilterSalary = (targetMin === 0 || jobSalaryMax >= targetMin) && (targetMax === 0 || jobSalaryMin <= targetMax);
      if (!ifFilterSalary) {
        console.log(`[Boss插件] 薪资过滤: 职位(${jobSalaryMin}-${jobSalaryMax}K) 不符合 要求(${targetMin}-${targetMax}K)`);
        return false;
      }
    }
  }
  if (isOnlyOnlineHr) {
    var onlineIcon = cardArea.querySelector(".boss-online-icon");
    if (!onlineIcon) {
      console.log(`[Boss插件] HR不在线，已过滤`);
      return false;
    }
  }
  var jobNameEl = cardArea.querySelector(".job-name");
  var jobName = jobNameEl ? jobNameEl.textContent.trim() : "";
  if (currentBlacklistKeywords.length > 0 && jobName) {
    const isBlackKeywordMatch = currentBlacklistKeywords.some((keyword) => {
      if (!keyword) return false;
      const keywordLower = keyword.toLowerCase();
      const jobNameLower = jobName.toLowerCase();
      const index2 = jobNameLower.indexOf(keywordLower);
      if (index2 !== -1) {
        const prefix = jobName.substring(Math.max(0, index2 - 1), index2);
        if (prefix === "非" || prefix === "不") {
          return false;
        }
        return true;
      }
      return false;
    });
    if (isBlackKeywordMatch) {
      console.log(`[Boss插件] 职位"${jobName}"包含黑名单关键词，已跳过`);
      return false;
    }
  }
  if (currentWhitelistKeywords.length > 0 && jobName) {
    const hasWhiteKeyword = currentWhitelistKeywords.some((keyword) => {
      if (!keyword) return false;
      return jobName.toLowerCase().includes(keyword.toLowerCase());
    });
    if (!hasWhiteKeyword) {
      console.log(`[Boss插件] 职位"${jobName}"不包含白名单关键词(${currentWhitelistKeywords.join(",")})，跳过`);
      return false;
    }
  }
  if (isSkipChatted) {
    var chatStatus = cardArea.querySelector(".start-chat-btn");
    if (chatStatus) {
      var chatText = chatStatus.textContent.trim();
      if (chatText.includes("继续沟通") || chatText.includes("已沟通")) {
        console.log(`[Boss插件] 职位"${jobName}"已沟通过，跳过`);
        return false;
      }
    }
    var chattedTag = cardArea.querySelector(".chat-status, .has-chatted");
    if (chattedTag) {
      console.log(`[Boss插件] 职位"${jobName}"已沟通过，跳过`);
      return false;
    }
  }
  return true;
}
async function pullFetchList() {
  var parentEl = document.querySelector(".job-list-container");
  var allTarget = document.querySelector(".rec-job-list").querySelectorAll(".card-area");
  var len = allTarget.length;
  var lastItem = allTarget[len - 1];
  const parentRect = parentEl.getBoundingClientRect();
  const targetRect = lastItem.getBoundingClientRect();
  const offset = targetRect.top - parentRect.top + parentEl.scrollTop;
  window.scrollTo({
    top: offset,
    behavior: "smooth"
  });
}
async function scrollToLoadMore() {
  const jobList = document.querySelector(".rec-job-list");
  const container = document.querySelector(".job-list-container");
  if (!jobList) {
    console.warn("[Boss插件] 找不到职位列表容器");
    return;
  }
  const allCards = jobList.querySelectorAll(".card-area");
  const lastCard = allCards[allCards.length - 1];
  if (lastCard) {
    lastCard.scrollIntoView({ behavior: "smooth", block: "end" });
  }
  await new Promise((resolve) => setTimeout(resolve, 300));
  window.scrollTo({
    top: document.body.scrollHeight,
    behavior: "smooth"
  });
  await new Promise((resolve) => setTimeout(resolve, 300));
  if (container) {
    container.scrollTop = container.scrollHeight;
  }
  await new Promise((resolve) => setTimeout(resolve, 300));
  window.dispatchEvent(new Event("scroll"));
  document.dispatchEvent(new Event("scroll"));
  await new Promise((resolve) => setTimeout(resolve, 200));
  window.scrollBy({ top: 500, behavior: "smooth" });
  console.log(`[Boss插件] 执行滚动加载，当前职位数: ${allCards.length}`);
}
async function isEndProcess() {
  if (!isExtensionContextValid()) {
    console.warn("[Boss插件] 扩展上下文已失效");
    hideInteractionBlocker();
    return true;
  }
  const storeData = await safeStorageGet(["isRunning", "deliverMaxNum"]);
  const maxNum = Number(storeData.deliverMaxNum) || 100;
  return new Promise((resolve) => {
    if (!storeData.isRunning) {
      hideInteractionBlocker();
      window.alert(`手动结束，共投递了（${deliveredCount}）份简历`);
      deliveredCount = 0;
      resolve(true);
    }
    if (deliveredCount < maxNum) {
      resolve(false);
    } else {
      console.log("[Boss插件] 已达到目标投递数量:", maxNum);
      hideInteractionBlocker();
      window.alert(`全部完成，共投递了（${deliveredCount}）份简历`);
      cleanSelectView();
      deliveredCount = 0;
      safeStorageSet({ isRunning: false });
      resolve(true);
    }
  });
}
function cleanSelectView() {
  var allUlTag = document.querySelector(".rec-job-list").querySelectorAll(".card-area");
  allUlTag.forEach((item) => {
    item.querySelector(".job-card-box").style.border = "none";
  });
}
function selectView(dom) {
  cleanSelectView();
  dom.querySelector(".job-card-box").style.border = "2px solid red";
}
function scrollIntoParentView(parentEl, targetEl) {
  if (!parentEl || !targetEl) return;
  const parentRect = parentEl.getBoundingClientRect();
  const targetRect = targetEl.getBoundingClientRect();
  const offset = targetRect.top - parentRect.top + parentEl.scrollTop;
  window.scrollTo({
    top: offset,
    behavior: "smooth"
  });
}
var scrollRetryCount = 0;
var totalNoDataRounds = 0;
const MAX_SCROLL_RETRY = 8;
const MAX_NO_DATA_ROUNDS = 3;
async function runningOne() {
  var _a;
  var isEnd = await isEndProcess();
  if (isEnd) return;
  if (positionsEligibleForApplication.length === 0) {
    const beforeScrollCount = ((_a = document.querySelector(".rec-job-list")) == null ? void 0 : _a.querySelectorAll(".card-area").length) || 0;
    console.log(`[Boss插件] 当前没有可投递的职位，滚动加载更多... (已加载 ${beforeScrollCount} 个职位, 重试 ${scrollRetryCount}/${MAX_SCROLL_RETRY}, 轮次 ${totalNoDataRounds}/${MAX_NO_DATA_ROUNDS})`);
    await scrollToLoadMore();
    const waitTime = 2e3 + scrollRetryCount * 300;
    setTimeout(async () => {
      var _a2;
      if (!isExtensionContextValid()) {
        console.warn("[Boss插件] 扩展上下文已失效，停止运行");
        return;
      }
      const runningState = await safeStorageGet("isRunning");
      if (!runningState.isRunning) {
        console.log("[Boss插件] 用户已停止，退出滚动");
        return;
      }
      const afterScrollCount = ((_a2 = document.querySelector(".rec-job-list")) == null ? void 0 : _a2.querySelectorAll(".card-area").length) || 0;
      const newTasks = await getCanRunTask();
      if (newTasks.length > 0) {
        scrollRetryCount = 0;
        totalNoDataRounds = 0;
        console.log(`[Boss插件] ✅ 找到 ${newTasks.length} 个符合条件的职位，继续投递`);
        runningOne();
      } else if (afterScrollCount > beforeScrollCount) {
        scrollRetryCount = 0;
        totalNoDataRounds = 0;
        console.log(`[Boss插件] 新加载了 ${afterScrollCount - beforeScrollCount} 个职位，但都不符合条件，继续滚动...`);
        runningOne();
      } else {
        scrollRetryCount++;
        if (scrollRetryCount < MAX_SCROLL_RETRY) {
          console.log(`[Boss插件] 本次滚动没有新数据，继续尝试... (${scrollRetryCount}/${MAX_SCROLL_RETRY})`);
          runningOne();
        } else {
          scrollRetryCount = 0;
          totalNoDataRounds++;
          if (totalNoDataRounds < MAX_NO_DATA_ROUNDS) {
            console.log(`[Boss插件] 第 ${totalNoDataRounds} 轮滚动完成，没有新数据，等待后继续下一轮...`);
            setTimeout(() => {
              runningOne();
            }, 3e3);
          } else {
            totalNoDataRounds = 0;
            console.warn("[Boss插件] 🛑 已连续多轮滚动无新数据，确认页面已到底");
            hideInteractionBlocker();
            window.alert(`已滚动到页面底部，没有更多符合条件的职位。

✅ 已投递: ${deliveredCount} 份
📋 已扫描: ${afterScrollCount} 个职位

建议：
1. 调整筛选条件（薪资范围、关键词等）
2. 更换搜索关键词后刷新页面
3. 换一个城市或职位类型试试`);
            safeStorageSet({ isRunning: false });
            cleanSelectView();
          }
        }
      }
    }, waitTime);
    return;
  }
  var item = positionsEligibleForApplication.shift();
  if (!item) {
    console.warn("[Boss插件] 待投递列表异常为空");
    return;
  }
  if (!isExtensionContextValid()) {
    console.warn("[Boss插件] 扩展上下文已失效，停止运行");
    return;
  }
  const tokenRes = await safeStorageGet("token");
  let companyBlacklist = [];
  if (tokenRes.token) {
    try {
      const companyRes = await http.get("/filterRule/list?type=3");
      if (companyRes.code === 200 && Array.isArray(companyRes.data)) {
        companyBlacklist = companyRes.data.map((i) => i.ruleValue);
      }
    } catch (e) {
      const storeData = await safeStorageGet("filterCompany");
      companyBlacklist = storeData.filterCompany || [];
    }
  } else {
    const storeData = await safeStorageGet("filterCompany");
    companyBlacklist = storeData.filterCompany || [];
  }
  const nameEl = item.querySelector(".boss-name") || item.querySelector(".company-name");
  const bossCompanyName = nameEl ? (nameEl.innerText || nameEl.textContent).trim() : "";
  if (Array.isArray(companyBlacklist) && companyBlacklist.length > 0 && bossCompanyName) {
    const isBlocked = companyBlacklist.some((blockedName) => {
      if (!blockedName) return false;
      return bossCompanyName.includes(blockedName) || blockedName.includes(bossCompanyName);
    });
    if (isBlocked) {
      console.log(`[Boss插件] 投递前二次拦截：公司"${bossCompanyName}"已在黑名单中，寻找下一个...`);
      runningOne();
      return;
    }
  }
  var container = document.querySelector(".job-list-container");
  if (positionsEligibleForApplication.length <= 2) {
    await pullFetchList();
    setTimeout(async () => {
      await getCanRunTask();
    }, 2e3);
  }
  scrollIntoParentView(container, item);
  item.click();
  selectView(item);
  safeStorageSet({ runningOneStatus: "running" });
  const chatUrl = item.querySelector(".job-name").href;
  if (isExtensionContextValid()) {
    chrome.runtime.sendMessage({ action: "open_new_tab", url: chatUrl });
  }
}
async function getCanRunTask() {
  var res = [];
  var allTarget = document.querySelector(".rec-job-list").querySelectorAll(".card-area");
  var len = allTarget.length;
  for (let i = loadJobCount; i < len; i++) {
    var isPass = await filterCondition(i);
    if (isPass) res.push(allTarget[i]);
  }
  loadJobCount = len;
  positionsEligibleForApplication = [...positionsEligibleForApplication, ...res];
  return res;
}
async function startProgram() {
  console.log("程序逻辑执行中...");
  showInteractionBlocker();
  await getCanRunTask();
  runningOne();
}
var deliveredCount = 0;
function injectStyles() {
  if (document.getElementById("boss-plugin-styles")) return;
  const style = document.createElement("style");
  style.id = "boss-plugin-styles";
  style.textContent = `
    .job-card-wrap, .card-area, .job-card-box { position: relative !important; }
    .boss-block-btn {
      position: absolute; top: 10px; right: 10px; padding: 4px 12px; font-size: 13px;
      color: #ff4d4f; background: #fff; border: 1px solid #ff4d4f; border-radius: 4px;
      cursor: pointer; z-index: 1000; transition: all 0.3s; display: none;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    .job-card-wrap:hover .boss-block-btn, 
    .card-area:hover .boss-block-btn,
    .job-card-box:hover .boss-block-btn { display: block !important; }
    .boss-block-btn:hover { background: #ff4d4f; color: white !important; }
    .boss-block-btn.blocked { background: #52c41a; color: white !important; border-color: #52c41a; }
    .is-blocked { opacity: 0.5 !important; background: #f5f5f5 !important; }
    .boss-progress-panel {
      position: fixed; top: 165px; left: 20px; background: white; border-radius: 12px;
      box-shadow: 0 4px 20px rgba(0,0,0,0.15); padding: 16px 20px; z-index: 99999;
      min-width: 180px; font-family: sans-serif; display: none;
    }
    .boss-progress-panel.show { display: block; }
    .boss-progress-title { font-size: 14px; font-weight: 600; margin-bottom: 12px; display: flex; align-items: center; gap: 8px; }
    .boss-progress-title .dot { width: 8px; height: 8px; background: #00bebd; border-radius: 50%; animation: pulse 1.5s infinite; }
    @keyframes pulse { 0%, 100% { opacity: 1; } 50% { opacity: 0.5; } }
    .boss-progress-stats { display: flex; justify-content: space-between; gap: 16px; }
    .boss-progress-item { text-align: center; }
    .boss-progress-item .number { font-size: 24px; font-weight: bold; color: #00bebd; }
    .boss-progress-bar { margin-top: 12px; height: 6px; background: #e5e7eb; border-radius: 3px; overflow: hidden; }
    .boss-progress-bar-fill { height: 100%; background: #00bebd; transition: width 0.3s; }
    /* 运行状态警告面板 */
    .boss-warning-panel {
      position: fixed; top: 80px; left: 20px; background: #fff2f0; border-radius: 12px;
      box-shadow: 0 4px 15px rgba(255, 77, 79, 0.15); border: 1px solid #ffccc7;
      padding: 12px 16px; z-index: 99999; min-width: 180px;
      display: flex; align-items: center; gap: 10px;
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }
    .boss-warning-icon { font-size: 18px; animation: warning-pulse 1.5s infinite; }
    @keyframes warning-pulse { 0% { opacity: 1; transform: scale(1); } 50% { opacity: 0.6; transform: scale(1.1); } 100% { opacity: 1; transform: scale(1); } }
    .boss-warning-content { font-family: sans-serif; }
    .boss-warning-title { font-size: 13px; font-weight: bold; color: #ff4d4f; margin-bottom: 2px; }
    .boss-warning-desc { font-size: 11px; color: #8c8c8c; }
    /* 交互遮罩层 */
    .boss-interaction-blocker {
      position: fixed; top: 0; left: 0; width: 100%; height: 100%;
      z-index: 99998; cursor: not-allowed;
      background: rgba(0, 0, 0, 0.03);
    }
    .boss-blocker-toast {
      position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%);
      background: rgba(0, 0, 0, 0.75); color: #fff; padding: 16px 32px;
      border-radius: 12px; font-size: 15px; z-index: 99999;
      pointer-events: none; opacity: 0; transition: opacity 0.3s;
      font-family: 'PingFang SC', 'Microsoft YaHei', sans-serif;
      box-shadow: 0 4px 20px rgba(0,0,0,0.3); text-align: center; line-height: 1.8;
    }
    .boss-blocker-toast.show { opacity: 1; }
  `;
  document.head.appendChild(style);
}
function createProgressPanel() {
  if (document.getElementById("boss-progress-panel")) return;
  const panel = document.createElement("div");
  panel.id = "boss-progress-panel";
  panel.className = "boss-progress-panel";
  panel.innerHTML = `
    <div class="boss-progress-title"><span class="dot"></span><span>投递进度</span></div>
    <div class="boss-progress-stats">
      <div class="boss-progress-item"><div class="number" id="boss-delivered-count">0</div><div class="label">已投递</div></div>
      <div class="boss-progress-item"><div class="number" id="boss-total-count">0</div><div class="label">目标数</div></div>
    </div>
    <div class="boss-progress-bar"><div class="boss-progress-bar-fill" id="boss-progress-fill" style="width: 0%"></div></div>
  `;
  document.body.appendChild(panel);
}
function updateProgressPanel() {
  const deliveredEl = document.getElementById("boss-delivered-count");
  const totalEl = document.getElementById("boss-total-count");
  const fillEl = document.getElementById("boss-progress-fill");
  if (deliveredEl && totalEl && fillEl) {
    deliveredEl.textContent = deliveredCount;
    totalEl.textContent = deliveryConfig.deliveryCount || 100;
    const percent = deliveryConfig.deliveryCount > 0 ? Math.min(deliveredCount / deliveryConfig.deliveryCount * 100, 100) : 0;
    fillEl.style.width = percent + "%";
  }
}
function showProgressPanel(show) {
  const panel = document.getElementById("boss-progress-panel");
  if (panel) panel.classList.toggle("show", show);
}
var blockerToastTimer = null;
function showInteractionBlocker() {
  if (document.getElementById("boss-interaction-blocker")) return;
  const blocker = document.createElement("div");
  blocker.id = "boss-interaction-blocker";
  blocker.className = "boss-interaction-blocker";
  const toast = document.createElement("div");
  toast.id = "boss-blocker-toast";
  toast.className = "boss-blocker-toast";
  toast.innerHTML = '程序正在自动运行中<br>请勿手动操作页面，以免干扰投递流程<br><small style="opacity:0.7">可通过插件面板点击「停止投递」来中断</small>';
  const warning = document.createElement("div");
  warning.id = "boss-warning-panel";
  warning.className = "boss-warning-panel";
  warning.innerHTML = `
    <div class="boss-warning-icon">⚠️</div>
    <div class="boss-warning-content">
      <div class="boss-warning-title">自动投递运行中...</div>
      <div class="boss-warning-desc">「停止投递」后即可恢复操作</div>
    </div>
  `;
  blocker.addEventListener("click", (e) => {
    e.stopPropagation();
    e.preventDefault();
    toast.classList.add("show");
    if (blockerToastTimer) clearTimeout(blockerToastTimer);
    blockerToastTimer = setTimeout(() => {
      toast.classList.remove("show");
    }, 2500);
  });
  document.body.appendChild(blocker);
  document.body.appendChild(toast);
  document.body.appendChild(warning);
  console.log("[Boss插件] 交互遮罩及警告面板已启用");
}
function hideInteractionBlocker() {
  const blocker = document.getElementById("boss-interaction-blocker");
  const toast = document.getElementById("boss-blocker-toast");
  const warning = document.getElementById("boss-warning-panel");
  if (blocker) blocker.remove();
  if (toast) toast.remove();
  if (warning) warning.remove();
  if (blockerToastTimer) {
    clearTimeout(blockerToastTimer);
    blockerToastTimer = null;
  }
  console.log("[Boss插件] 交互遮罩已移除");
}
const originalClick = HTMLElement.prototype.click;
HTMLElement.prototype.click = function() {
  const blocker = document.getElementById("boss-interaction-blocker");
  if (blocker) {
    blocker.style.pointerEvents = "none";
    originalClick.call(this);
    requestAnimationFrame(() => {
      if (blocker && blocker.parentNode) {
        blocker.style.pointerEvents = "";
      }
    });
  } else {
    originalClick.call(this);
  }
};
async function blockCompany(companyName, btn, cardWrap) {
  if (!isExtensionContextValid()) return;
  const tokenRes = await safeStorageGet("token");
  if (!tokenRes.token) {
    alert("请先登录后再使用拉黑功能");
    return;
  }
  const result = await safeStorageGet("filterCompany");
  let filterList = result.filterCompany;
  if (!Array.isArray(filterList)) {
    filterList = [];
  }
  if (!filterList.includes(companyName)) {
    filterList.push(companyName);
    await safeStorageSet({ filterCompany: filterList });
    btn.textContent = "解除";
    btn.classList.add("blocked");
    cardWrap == null ? void 0 : cardWrap.classList.add("is-blocked");
    btn.onclick = (e) => {
      e.stopPropagation();
      unblockCompany(companyName, btn, cardWrap);
    };
    try {
      await http.post("/filterRule/add", { ruleType: 3, ruleValue: companyName });
      console.log("[Boss插件] 拉黑公司已同步到数据库:", companyName);
    } catch (err) {
      console.error("[Boss插件] 同步拉黑公司失败:", err);
    }
  }
}
async function unblockCompany(companyName, btn, cardWrap) {
  if (!isExtensionContextValid()) return;
  const tokenRes = await safeStorageGet("token");
  if (!tokenRes.token) {
    alert("请先登录后再使用解除功能");
    return;
  }
  const result = await safeStorageGet("filterCompany");
  let filterList = result.filterCompany;
  if (!Array.isArray(filterList)) {
    filterList = [];
  }
  filterList = filterList.filter((name) => name !== companyName);
  await safeStorageSet({ filterCompany: filterList });
  btn.textContent = "拉黑";
  btn.classList.remove("blocked");
  cardWrap == null ? void 0 : cardWrap.classList.remove("is-blocked");
  btn.onclick = (e) => {
    e.stopPropagation();
    blockCompany(companyName, btn, cardWrap);
  };
  try {
    await http.delete(`/filterRule/deleteByValue?type=3&value=${encodeURIComponent(companyName)}`);
    console.log("[Boss插件] 解除拉黑已同步到数据库:", companyName);
  } catch (err) {
    console.error("[Boss插件] 同步解除拉黑失败:", err);
  }
}
function addBlockButtons() {
  if (!isExtensionContextValid()) return;
  chrome.storage.local.get(["token", "filterCompany"], (res) => {
    const token = res.token;
    let filterList = res.filterCompany;
    if (!Array.isArray(filterList)) {
      filterList = [];
    }
    const items = document.querySelectorAll(".job-card-wrap, .card-area, .view-card-area");
    items.forEach((card) => {
      if (card.querySelector(".boss-block-btn")) return;
      if (card.closest(".job-card-wrap") && card.classList.contains("job-card-box")) return;
      const nameEl = card.querySelector(".boss-name") || card.querySelector(".company-name");
      if (!nameEl) return;
      card.style.position = "relative";
      const companyName = nameEl.textContent.trim();
      const btn = document.createElement("button");
      btn.className = "boss-block-btn";
      if (!token) {
        btn.textContent = "登录拉黑";
        btn.onclick = (e) => {
          e.stopPropagation();
          e.preventDefault();
          alert("请先登录后再使用拉黑功能");
        };
      } else if (filterList.includes(companyName)) {
        btn.textContent = "解除";
        btn.classList.add("blocked");
        card.classList.add("is-blocked");
        btn.onclick = (e) => {
          e.stopPropagation();
          e.preventDefault();
          unblockCompany(companyName, btn, card);
        };
      } else {
        btn.textContent = "拉黑";
        btn.onclick = (e) => {
          e.stopPropagation();
          e.preventDefault();
          blockCompany(companyName, btn, card);
        };
      }
      card.appendChild(btn);
    });
  });
}
function observeJobList() {
  const container = document.querySelector(".job-list-container") || document.querySelector(".rec-job-list") || document.body;
  const observer = new MutationObserver((mutations) => {
    if (this.timer) clearTimeout(this.timer);
    this.timer = setTimeout(() => {
      addBlockButtons();
    }, 300);
  });
  observer.observe(container, {
    childList: true,
    subtree: true,
    attributes: true,
    // 监听属性变化，捕获 active 等类名切换导致的重新渲染
    attributeFilter: ["class"]
  });
  window.addEventListener("scroll", () => setTimeout(addBlockButtons, 300));
  setInterval(addBlockButtons, 2e3);
}
chrome.storage.onChanged.addListener((changes) => {
  var _a, _b;
  if (!isExtensionContextValid()) {
    console.warn("[Boss插件] 扩展上下文已失效，忽略 storage 变化");
    return;
  }
  if (((_a = changes.runningOneStatus) == null ? void 0 : _a.newValue) === "done") {
    deliveredCount++;
    updateProgressPanel();
    safeStorageGet(["token", "trialCount", "maxTrialCount", "delayMin", "delayMax"]).then((res) => {
      const delayMinVal = res.delayMin !== void 0 ? res.delayMin : deliveryConfig.delayMin || 3;
      const delayMaxVal = res.delayMax !== void 0 ? res.delayMax : deliveryConfig.delayMax || 4;
      const minMs = delayMinVal * 1e3;
      const maxMs = delayMaxVal * 1e3;
      const random = Math.floor(Math.random() * (maxMs - minMs + 1)) + minMs;
      console.log(`[Boss插件] 延迟配置: ${delayMinVal}-${delayMaxVal}秒，本次随机: ${random}ms`);
      if (!res.token) {
        const currentCount = res.trialCount || 0;
        const max = res.maxTrialCount || 10;
        const newCount = currentCount + 1;
        safeStorageSet({ trialCount: newCount });
        console.log(`[Boss插件] 试用计数更新: ${newCount}/${max}`);
        if (newCount >= max) {
          safeStorageSet({ isRunning: false });
          console.warn("[Boss插件] 试用次数已达上限，程序已中止");
          return;
        }
      }
      console.log("[Boss插件] 完成了一个投递，随机等待：", random, "ms");
      var T2 = setTimeout(() => {
        clearTimeout(T2);
        runningOne();
      }, random);
    });
  }
  if (((_b = changes.runningOneStatus) == null ? void 0 : _b.newValue) === "skipped") {
    console.log("[Boss插件] 职位已跳过（已沟通），快速继续下一个...");
    var T = setTimeout(() => {
      clearTimeout(T);
      runningOne();
    }, 500);
  }
  if (changes.isRunning) {
    const isRunningNow = changes.isRunning.newValue;
    showProgressPanel(isRunningNow);
    if (isRunningNow) {
      deliveredCount = 0;
      loadJobCount = 0;
      positionsEligibleForApplication = [];
      console.log("[Boss插件] 程序启动，重置扫描状态和队列");
      updateProgressPanel();
    } else {
      hideInteractionBlocker();
      cleanSelectView();
      console.log("[Boss插件] 程序已停止，清理所有运行期 UI");
    }
  }
  if (changes.deliverMaxNum) deliveryConfig.deliveryCount = Number(changes.deliverMaxNum.newValue);
  if (changes.salaryMin) deliveryConfig.salaryMin = Number(changes.salaryMin.newValue);
  if (changes.salaryMax) deliveryConfig.salaryMax = Number(changes.salaryMax.newValue);
  if (changes.onlyOnline) deliveryConfig.onlyOnlineHr = changes.onlyOnline.newValue ? 1 : 0;
  if (changes.skipChatted) deliveryConfig.skipCommunicated = changes.skipChatted.newValue ? 1 : 0;
  if (changes.autoReply) deliveryConfig.autoReply = changes.autoReply.newValue ? 1 : 0;
  if (changes.delayMin) deliveryConfig.delayMin = Number(changes.delayMin.newValue);
  if (changes.delayMax) deliveryConfig.delayMax = Number(changes.delayMax.newValue);
  if (changes.blacklistKeywords) blacklistKeywords = changes.blacklistKeywords.newValue || [];
  if (changes.whitelistKeywords) whitelistKeywords = changes.whitelistKeywords.newValue || [];
  updateProgressPanel();
});
window.onload = async function() {
  await syncConfigFromStorage();
  injectStyles();
  createProgressPanel();
  updateProgressPanel();
  chrome.storage.local.get("isRunning", (d) => {
    if (d.isRunning) showProgressPanel(true);
  });
  setTimeout(addBlockButtons, 500);
  observeJobList();
};
