const baseUrl = "http://localhost:8002";
const http = {
  fetchWithToken: async (url, options = {}) => {
    const res = await chrome.storage.local.get("token");
    const token = res.token || "";
    const headers = {
      "Content-Type": "application/json",
      ...options.headers
    };
    if (token) headers["Authorization"] = token;
    const response = await fetch(`${baseUrl}${url}`, { ...options, headers });
    return await response.json();
  },
  get: (url) => http.fetchWithToken(url, { method: "GET" }),
  post: (url, data) => http.fetchWithToken(url, { method: "POST", body: JSON.stringify(data) }),
  delete: (url) => http.fetchWithToken(url, { method: "DELETE" })
};
var text = ``;
window.onload = function() {
  chrome.storage.local.get("isRunning", (data) => {
    if (data.isRunning) {
      observeChatBox();
    }
  });
  console.log("[Boss插件] chat.js 加载完成");
  chrome.storage.local.get(["text", "aiGeneratedText"], (data) => {
    console.log("[Boss插件] 获取到模板:", data.text, "AI生成内容:", data.aiGeneratedText);
    if (data.aiGeneratedText) {
      text = data.aiGeneratedText;
      console.log("[Boss插件] 检测到 AI 生成的打招呼语");
    } else if (data.text) {
      text = data.text;
    }
  });
  injectChatStyles();
  setTimeout(addBlockButtonsToChat, 500);
  observeChatList();
};
async function waitForHRSelected(maxRetries = 10, interval = 300) {
  console.log("[Boss插件] 开始等待HR被选中...");
  for (let i = 0; i < maxRetries; i++) {
    const selectedSelectors = [
      ".friend-content.selected",
      "li[role='listitem'].selected",
      ".friend-content-warp.selected",
      "li[role='listitem'] .friend-content.selected"
    ];
    for (const selector of selectedSelectors) {
      const selectedElement = document.querySelector(selector);
      if (selectedElement) {
        console.log(`[Boss插件] 第${i + 1}次尝试：HR已被选中 (${selector})`);
        return true;
      }
    }
    if (i === 2) {
      console.log("[Boss插件] HR未自动选中，尝试主动选中...");
      const autoSelectResult = await tryAutoSelectHR();
      if (autoSelectResult) {
        console.log("[Boss插件] 主动选中HR成功");
        return true;
      }
    }
    console.log(`[Boss插件] 第${i + 1}次尝试：HR未选中，等待${interval}ms后重试...`);
    await new Promise((resolve) => setTimeout(resolve, interval));
  }
  console.warn("[Boss插件] 等待HR选中超时");
  return false;
}
async function tryAutoSelectHR() {
  const urlParams = new URLSearchParams(window.location.search);
  urlParams.get("id") || urlParams.get("chatId");
  const chatItems = document.querySelectorAll('li[role="listitem"]');
  if (chatItems.length > 0) {
    const selectedItem = document.querySelector('li[role="listitem"].selected, li[role="listitem"] .friend-content.selected');
    if (!selectedItem) {
      const firstItem = chatItems[0];
      const clickTarget = firstItem.querySelector(".friend-content-warp") || firstItem;
      console.log("[Boss插件] 尝试点击第一个聊天项进行选中");
      clickTarget.click();
      await new Promise((resolve) => setTimeout(resolve, 500));
      return true;
    }
  }
  const chatListContainer = document.querySelector(".user-list-content");
  if (chatListContainer) {
    chatListContainer.scrollTop += 1;
    chatListContainer.scrollTop -= 1;
    await new Promise((resolve) => setTimeout(resolve, 300));
  }
  return false;
}
function getBossName() {
  console.log("[Boss插件] 开始获取HR姓名");
  const selectors = [
    ".friend-content.selected .name-text",
    ".friend-content.selected .name-box .name-text",
    ".selected .name-text",
    "li[role='listitem'] .selected .name-text",
    "li[role='listitem'].selected .name-text",
    ".friend-content-warp .selected .name-text",
    // 备选：如果没有选中状态，尝试从右侧聊天窗口标题获取
    ".chat-conversation .name",
    ".chat-nickname",
    ".message-title .name"
  ];
  for (const selector of selectors) {
    const nameElement = document.querySelector(selector);
    if (nameElement) {
      const bossName = nameElement.textContent.trim();
      if (bossName) {
        console.log(`[Boss插件] 从 ${selector} 获取到HR姓名: ${bossName}`);
        return bossName.charAt(0);
      }
    }
  }
  console.warn("[Boss插件] 无法获取HR姓名");
  return null;
}
function observeChatBox() {
  const observer = new MutationObserver(async () => {
    const chatInput = document.querySelector(".chat-input");
    const sendButton = document.querySelector(".btn-v2.btn-sure-v2.btn-send");
    if (chatInput && sendButton) {
      observer.disconnect();
      chrome.storage.local.get(["autoReply", "lastHistoryId"], async (res) => {
        const isAutoReply = res.autoReply !== false;
        if (!isAutoReply) {
          console.log("[Boss插件] 自动回复已关闭，跳过发送");
          setTimeout(() => {
            chrome.storage.local.set({ runningOneStatus: "done" });
            chrome.runtime.sendMessage({ action: "close_current_tab" });
          }, 1e3);
          return;
        }
        const hrSelected = await waitForHRSelected(5, 200);
        if (!hrSelected) {
          console.warn("[Boss插件] HR未能被选中，但仍尝试发送消息");
        }
        await new Promise((resolve) => setTimeout(resolve, 100));
        const storageData = await chrome.storage.local.get(["aiGeneratedText", "text"]);
        let finalText;
        if (storageData.aiGeneratedText) {
          finalText = storageData.aiGeneratedText;
          chrome.storage.local.remove("aiGeneratedText");
          console.log("[Boss插件] 使用 AI 生成的打招呼语:", finalText);
        } else {
          const surname = getBossName();
          finalText = storageData.text || text;
          if (surname) {
            finalText = `${surname}老师，${finalText}`;
            console.log(`[Boss插件] 使用HR姓氏: ${surname}`);
          } else {
            console.warn("[Boss插件] 未获取到HR姓名，使用原始模板");
          }
        }
        chatInput.innerHTML = finalText;
        setTimeout(() => {
          sendButton.click();
          console.log("[Boss插件] 已点击发送按钮");
          if (res.lastHistoryId) {
            http.post("/deliveryHistory/updateStatus", {
              historyId: res.lastHistoryId,
              status: "sent"
            }).then(() => {
              console.log("[Boss插件] 状态已更新为 sent");
              chrome.storage.local.remove("lastHistoryId");
            }).catch((err) => {
              console.error("[Boss插件] 状态更新失败:", err);
            });
          }
          setTimeout(() => {
            chrome.storage.local.set({ runningOneStatus: "done" });
            chrome.runtime.sendMessage({ action: "close_current_tab" });
            console.log("[Boss插件] 已关闭聊天窗口");
          }, 300);
        }, 200);
      });
    }
  });
  observer.observe(document.body, { childList: true, subtree: true });
}
function injectChatStyles() {
  if (document.getElementById("boss-chat-plugin-styles")) return;
  const style = document.createElement("style");
  style.id = "boss-chat-plugin-styles";
  style.textContent = `
    .boss-chat-block-btn {
      position: absolute; top: 50%; right: 50px; transform: translateY(-50%);
      padding: 4px 10px; font-size: 11px; color: #ff4d4f; background: #fff1f0;
      border: 1px solid #ffccc7; border-radius: 4px; cursor: pointer; z-index: 100;
      transition: all 0.2s; opacity: 0; pointer-events: none;
    }
    .boss-chat-block-btn:hover { background: #ff4d4f; color: white; border-color: #ff4d4f; }
    .friend-content-warp:hover .boss-chat-block-btn,
    li[role="listitem"]:hover .boss-chat-block-btn { opacity: 1; pointer-events: auto; }
    .boss-chat-block-btn.blocked { background: #52c41a; color: white; border-color: #52c41a; }
    li[role="listitem"].is-blocked .friend-content-warp,
    .friend-content-warp.is-blocked { opacity: 0.5; background: rgba(245, 245, 245, 0.8); }
    .friend-content-warp { position: relative; }
  `;
  document.head.appendChild(style);
}
async function blockCompanyFromChat(companyName, btn, chatItem) {
  const tokenRes = await chrome.storage.local.get("token");
  if (!tokenRes.token) {
    alert("请先登录后再使用拉黑功能");
    return;
  }
  const result = await chrome.storage.local.get("filterCompany");
  let filterList = result.filterCompany;
  if (!Array.isArray(filterList)) {
    filterList = [];
  }
  if (filterList.includes(companyName)) return;
  filterList.push(companyName);
  await chrome.storage.local.set({ filterCompany: filterList });
  btn.textContent = "解除";
  btn.classList.add("blocked");
  if (chatItem) chatItem.classList.add("is-blocked");
  btn.onclick = (e) => {
    e.stopPropagation();
    e.preventDefault();
    unblockCompanyFromChat(companyName, btn, chatItem);
  };
  try {
    await http.post("/filterRule/add", { ruleType: 3, ruleValue: companyName });
    console.log("[Boss插件] 拉黑公司已同步到数据库:", companyName);
  } catch (err) {
    console.error("[Boss插件] 同步拉黑公司失败:", err);
  }
}
async function unblockCompanyFromChat(companyName, btn, chatItem) {
  const tokenRes = await chrome.storage.local.get("token");
  if (!tokenRes.token) {
    alert("请先登录后再使用解除功能");
    return;
  }
  const result = await chrome.storage.local.get("filterCompany");
  let filterList = result.filterCompany;
  if (!Array.isArray(filterList)) {
    filterList = [];
  }
  filterList = filterList.filter((name) => name !== companyName);
  await chrome.storage.local.set({ filterCompany: filterList });
  btn.textContent = "拉黑";
  btn.classList.remove("blocked");
  if (chatItem) chatItem.classList.remove("is-blocked");
  btn.onclick = (e) => {
    e.stopPropagation();
    e.preventDefault();
    blockCompanyFromChat(companyName, btn, chatItem);
  };
  try {
    await http.delete(`/filterRule/deleteByValue?type=3&value=${encodeURIComponent(companyName)}`);
    console.log("[Boss插件] 解除拉黑已同步到数据库:", companyName);
  } catch (err) {
    console.error("[Boss插件] 同步解除拉黑失败:", err);
  }
}
function addBlockButtonsToChat() {
  chrome.storage.local.get(["token", "filterCompany"], (res) => {
    const token = res.token;
    let filterList = res.filterCompany;
    if (!Array.isArray(filterList)) {
      filterList = [];
    }
    const chatItems = document.querySelectorAll('li[role="listitem"]');
    chatItems.forEach((item) => {
      if (item.querySelector(".boss-chat-block-btn")) return;
      const nameBox = item.querySelector(".name-box");
      if (!nameBox) return;
      const spans = nameBox.querySelectorAll("span");
      if (spans.length < 2) return;
      const companyName = spans[1].textContent.trim();
      if (!companyName) return;
      const contentWarp = item.querySelector(".friend-content-warp");
      if (!contentWarp) return;
      contentWarp.style.position = "relative";
      const btn = document.createElement("button");
      btn.className = "boss-chat-block-btn";
      if (!token) {
        btn.textContent = "登录拉黑";
        btn.onclick = (e) => {
          e.stopPropagation();
          e.preventDefault();
          alert("请先登录后再使用拉黑功能");
        };
      } else if (filterList.some((name) => companyName.includes(name) || name.includes(companyName))) {
        btn.textContent = "解除";
        btn.classList.add("blocked");
        item.classList.add("is-blocked");
        btn.onclick = (e) => {
          e.stopPropagation();
          e.preventDefault();
          unblockCompanyFromChat(companyName, btn, item);
        };
      } else {
        btn.textContent = "拉黑";
        btn.onclick = (e) => {
          e.stopPropagation();
          e.preventDefault();
          blockCompanyFromChat(companyName, btn, item);
        };
      }
      contentWarp.appendChild(btn);
    });
  });
}
function observeChatList() {
  const container = document.querySelector(".user-list-content") || document.querySelector('ul[role="group"]') || document.querySelector(".chat-list");
  if (!container) {
    setTimeout(observeChatList, 1e3);
    return;
  }
  new MutationObserver(() => setTimeout(addBlockButtonsToChat, 200)).observe(container, { childList: true, subtree: true });
  const scrollContainer = document.querySelector(".user-list-content") || window;
  scrollContainer.addEventListener("scroll", () => setTimeout(addBlockButtonsToChat, 300));
  setInterval(() => {
    const items = document.querySelectorAll('li[role="listitem"]');
    if (Array.from(items).some((item) => !item.querySelector(".boss-chat-block-btn"))) addBlockButtonsToChat();
  }, 2e3);
}
