chrome.runtime.onInstalled.addListener(() => {
  console.log("Extension installed!");
});
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === "close_current_tab" && sender.tab) {
    chrome.tabs.remove(sender.tab.id);
    sendResponse({ success: true });
    return;
  }
  if (request.action === "open_new_tab") {
    chrome.tabs.create({
      url: request.url,
      active: false
    });
    sendResponse({ success: true });
    return;
  }
  if (request.type === "status") {
    chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
      if (tabs.length > 0) {
        const activeTab = tabs[0];
        chrome.tabs.sendMessage(activeTab.id, request, (response) => {
          if (chrome.runtime.lastError) {
            console.warn("[Boss插件] 无法连接到内容脚本:", chrome.runtime.lastError.message);
            sendResponse({
              error: "请确保您当前正处于 Boss直聘 的职位列表页面，并且已刷新页面。",
              detail: chrome.runtime.lastError.message
            });
          } else {
            sendResponse(response);
          }
        });
      } else {
        sendResponse({ error: "找不到活动标签页" });
      }
    });
    return true;
  }
});
